/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.LoggerFactory;

public class TaskUpdateThemeImport
implements FallibleCommand {
    public static final String APPLICATION_META_INF_RESOURCES = "src/main/resources/META-INF/resources";
    public static final String APPLICATION_STATIC_RESOURCES = "src/main/resources/static";
    private static final String EXPORT_MODULES_DEF = "export declare const applyTheme: (target: Node) => void;";
    private final File themeImportFile;
    private final File themeImportFileDefinition;
    private final ThemeDefinition theme;
    private final File frontendDirectory;
    private final File npmFolder;

    TaskUpdateThemeImport(File npmFolder, ThemeDefinition theme, File frontendDirectory, File frontendGeneratedFolder) {
        this.theme = theme;
        this.frontendDirectory = frontendDirectory;
        this.npmFolder = npmFolder;
        this.themeImportFile = new File(frontendGeneratedFolder, "theme.js");
        this.themeImportFileDefinition = new File(frontendGeneratedFolder, "theme.d.ts");
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.theme == null || this.theme.getName().isEmpty()) {
            if (this.themeImportFile.exists()) {
                this.themeImportFile.delete();
                this.themeImportFileDefinition.delete();
            }
            return;
        }
        this.verifyThemeDirectoryExistence();
        if (!this.themeImportFile.getParentFile().mkdirs()) {
            LoggerFactory.getLogger(this.getClass()).debug("Didn't create folders as they probably already exist. If there is a problem check access rights for folder {}", (Object)this.themeImportFile.getParentFile().getAbsolutePath());
        }
        try {
            FileUtils.write((File)this.themeImportFile, (CharSequence)String.format("import {applyTheme as _applyTheme} from './theme-%s.generated.js';%nexport const applyTheme = _applyTheme;%n", this.theme.getName()), (Charset)StandardCharsets.UTF_8);
            FileUtils.write((File)this.themeImportFileDefinition, (CharSequence)EXPORT_MODULES_DEF, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ExecutionFailedException("Unable to write theme import file", e);
        }
    }

    private void verifyThemeDirectoryExistence() throws ExecutionFailedException {
        String themeName = this.theme.getName();
        String themePath = String.join((CharSequence)"/", "themes", themeName);
        List<String> appThemePossiblePaths = this.getAppThemePossiblePaths(themePath);
        List existingAppThemeDirectories = appThemePossiblePaths.stream().map(path -> new File(this.npmFolder, (String)path)).filter(File::exists).collect(Collectors.toList());
        if (existingAppThemeDirectories.isEmpty()) {
            String errorMessage = "Discovered @Theme annotation with theme name '%s', but could not find the theme directory in the project or available as a jar dependency. Check if you forgot to create the folder under '%s' or have mistyped the theme or folder name for '%s'.";
            throw new ExecutionFailedException(String.format(errorMessage, themeName, new File(this.frontendDirectory, "themes").getPath(), themeName));
        }
        if (existingAppThemeDirectories.size() >= 2) {
            boolean themeFoundInJar = existingAppThemeDirectories.stream().map(File::getPath).anyMatch(path -> path.contains(Paths.get("@vaadin/flow-frontend/", new String[0]).toString()));
            if (themeFoundInJar) {
                String errorMessage = "Theme '%s' should not exist inside a jar and in the project at the same time.%nExtending another theme is possible by adding { \"parent\": \"your-parent-theme\" } entry to the 'theme.json' file inside your theme folder.";
                throw new ExecutionFailedException(String.format(errorMessage, themeName));
            }
            String errorMessage = "Discovered Theme folder for theme '%s' in more than one place in the project. Please make sure there is only one theme folder with name '%s' exists in the your project. The recommended place to put the theme folder inside the project is '%s'";
            throw new ExecutionFailedException(String.format(errorMessage, themeName, themeName, new File(this.frontendDirectory, "themes").getPath()));
        }
    }

    private List<String> getAppThemePossiblePaths(String themePath) {
        String frontendTheme = String.join((CharSequence)"/", this.npmFolder.toPath().relativize(this.frontendDirectory.toPath()).toString(), themePath);
        String themePathInMetaInfResources = String.join((CharSequence)"/", APPLICATION_META_INF_RESOURCES, themePath);
        String themePathInStaticResources = String.join((CharSequence)"/", APPLICATION_STATIC_RESOURCES, themePath);
        String themePathInClassPathResources = String.join((CharSequence)"", "node_modules/", "@vaadin/flow-frontend/", themePath);
        return Arrays.asList(frontendTheme, themePathInMetaInfResources, themePathInStaticResources, themePathInClassPathResources);
    }
}

