/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.flow.testcategory.ChromeTests;
import com.vaadin.flow.testutil.ChromeDriverLocator;
import com.vaadin.flow.testutil.ViewOrUITest;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.parallel.Browser;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

@Category(value={ChromeTests.class})
public class ChromeBrowserTest
extends ViewOrUITest {
    @BeforeClass
    public static void setChromeDriverPath() {
        ChromeDriverLocator.fillEnvironmentProperty();
    }

    @Before
    public void setup() throws Exception {
        if (Browser.CHROME == this.getRunLocallyBrowser() && !ChromeBrowserTest.isJavaInDebugMode()) {
            this.setDriver(ChromeBrowserTest.createHeadlessChromeDriver());
        } else {
            super.setup();
        }
    }

    static boolean isJavaInDebugMode() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    }

    static WebDriver createHeadlessChromeDriver() {
        return TestBench.createDriver((WebDriver)new ChromeDriver(ChromeBrowserTest.createHeadlessChromeOptions()));
    }

    @Override
    protected List<DesiredCapabilities> getHubBrowsersToTest() {
        if (!this.getLocalExecution().isPresent() && USE_BROWSERSTACK) {
            return this.getBrowserCapabilities(Browser.IE11);
        }
        return this.getBrowserCapabilities(Browser.CHROME);
    }

    @Override
    protected List<DesiredCapabilities> getBrowserCapabilities(Browser ... browsers) {
        return this.customizeCapabilities(super.getBrowserCapabilities(browsers));
    }

    protected List<DesiredCapabilities> customizeCapabilities(List<DesiredCapabilities> capabilities) {
        capabilities.stream().filter(cap -> "chrome".equalsIgnoreCase(cap.getBrowserName())).forEach(cap -> cap.setCapability("goog:chromeOptions", (Object)ChromeBrowserTest.createHeadlessChromeOptions()));
        return capabilities;
    }

    static ChromeOptions createHeadlessChromeOptions() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless", "--disable-gpu"});
        return options;
    }
}

