/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;

final class ChromeDriverLocator {
    private static final String WEBDRIVER_CHROME_DRIVER = "webdriver.chrome.driver";
    private static final String CHROMEDRIVER_NAME_PART = "chromedriver";
    private static final int MAX_DRIVER_SEARCH_DEPTH = 4;

    private ChromeDriverLocator() {
    }

    static void fillEnvironmentProperty() {
        if (System.getProperty(WEBDRIVER_CHROME_DRIVER) == null) {
            Optional.ofNullable(ChromeDriverLocator.getDriverLocation()).ifPresent(driverLocation -> System.setProperty(WEBDRIVER_CHROME_DRIVER, driverLocation));
        }
    }

    private static String getDriverLocation() {
        Path driverDirectory = Paths.get("../../driver/", new String[0]);
        if (!driverDirectory.toFile().isDirectory()) {
            System.out.println(String.format("Could not find driver directory: %s", driverDirectory));
            return null;
        }
        List<Path> driverPaths = ChromeDriverLocator.getDriverPaths(driverDirectory);
        if (driverPaths.isEmpty()) {
            System.out.println("No chromedriver found at \"" + driverDirectory.toAbsolutePath() + "\"\n  Verify that the path is correct and that driver-binary-downloader-maven-plugin has been run at least once.");
            return null;
        }
        if (driverPaths.size() > 1) {
            System.out.println(String.format("Have found multiple driver paths, using the first one from the list: %s", driverPaths));
        }
        return driverPaths.get(0).toAbsolutePath().toString();
    }

    private static List<Path> getDriverPaths(Path driverDirectory) {
        List<Path> driverPaths;
        try {
            driverPaths = Files.find(driverDirectory, 4, ChromeDriverLocator::isChromeDriver, new FileVisitOption[0]).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error trying to locate chromedriver binary", e);
        }
        return driverPaths;
    }

    private static boolean isChromeDriver(Path path, BasicFileAttributes attributes) {
        return attributes.isRegularFile() && path.toString().toLowerCase(Locale.getDefault()).contains(CHROMEDRIVER_NAME_PART);
    }
}

