/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.testbench.parallel.ParallelTest;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.slf4j.LoggerFactory;

public class TestBenchHelpers
extends ParallelTest {
    private static final String WEB_SOCKET_CONNECTION_ERROR_PREFIX = "WebSocket connection to ";

    protected <T> void waitUntilNot(ExpectedCondition<T> condition) {
        this.waitUntilNot(condition, 10L);
    }

    public boolean isElementPresent(By by) {
        try {
            WebElement element = this.getDriver().findElement(by);
            return element != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void dragAndDrop(WebElement source, WebElement target) {
        this.getCommandExecutor().executeScript(LazyDndSimulationLoad.DND_SCRIPT, new Object[]{source, target, "DND"});
    }

    public void drag(WebElement source) {
        this.getCommandExecutor().executeScript(LazyDndSimulationLoad.DND_SCRIPT, new Object[]{source, null, "DRAG"});
    }

    public void dragElementOver(WebElement source, WebElement target) {
        this.getCommandExecutor().executeScript(LazyDndSimulationLoad.DND_SCRIPT, new Object[]{source, target, "DRAG_OVER"});
    }

    protected <T> void waitUntilNot(ExpectedCondition<T> condition, long timeoutInSeconds) {
        this.waitUntil(ExpectedConditions.not(condition), timeoutInSeconds);
    }

    protected void waitForElementPresent(By by) {
        this.waitUntil(ExpectedConditions.presenceOfElementLocated((By)by));
    }

    protected void waitForElementNotPresent(By by) {
        this.waitUntil(input -> input.findElements(by).isEmpty());
    }

    protected void waitForElementVisible(By by) {
        this.waitUntil(ExpectedConditions.visibilityOfElementLocated((By)by));
    }

    protected boolean hasCssClass(WebElement element, String className) {
        String classes = element.getAttribute("class");
        if (classes == null || classes.isEmpty()) {
            return className == null || className.isEmpty();
        }
        return Stream.of(classes.split(" ")).anyMatch(className::equals);
    }

    protected static void assertEquals(WebElement expectedElement, WebElement actualElement) {
        WebElement unwrappedExpected = expectedElement;
        WebElement unwrappedActual = actualElement;
        while (unwrappedExpected instanceof WrapsElement) {
            unwrappedExpected = ((WrapsElement)unwrappedExpected).getWrappedElement();
        }
        while (unwrappedActual instanceof WrapsElement) {
            unwrappedActual = ((WrapsElement)unwrappedActual).getWrappedElement();
        }
        Assert.assertEquals((Object)unwrappedExpected, (Object)unwrappedActual);
    }

    protected boolean isPresentInShadowRoot(WebElement webComponent, By by) {
        return !this.findInShadowRoot(webComponent, by).isEmpty();
    }

    protected WebElement getInShadowRoot(WebElement shadowRootOwner, By by) {
        return (WebElement)this.getShadowRoot(shadowRootOwner).findElements(by).stream().findFirst().orElseThrow(() -> new AssertionError((Object)"Could not find required element in the shadowRoot"));
    }

    protected List<WebElement> findInShadowRoot(WebElement webComponent, By by) {
        return this.getShadowRoot(webComponent).findElements(by);
    }

    protected Object executeScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.getDriver()).executeScript(script, args);
    }

    protected void scrollBy(int deltaX, int deltaY) {
        this.executeScript("window.scrollBy(" + deltaX + ',' + deltaY + ");", new Object[0]);
    }

    protected void scrollToElement(WebElement element) {
        Objects.requireNonNull(element, "The element to scroll to should not be null");
        this.getCommandExecutor().executeScript("arguments[0].scrollIntoView(true);", new Object[]{element});
    }

    protected void scrollIntoViewAndClick(WebElement element) {
        this.scrollToElement(element);
        element.click();
    }

    protected int getScrollX() {
        return ((Long)this.executeScript("return window.pageXOffset", new Object[0])).intValue();
    }

    protected int getScrollY() {
        return ((Long)this.executeScript("return window.pageYOffset", new Object[0])).intValue();
    }

    protected void clickElementWithJs(String elementId) {
        this.executeScript(String.format("document.getElementById('%s').click();", elementId), new Object[0]);
    }

    protected void clickElementWithJs(WebElement element) {
        this.executeScript("arguments[0].click();", element);
    }

    protected List<LogEntry> getLogEntries(Level level) {
        this.getCommandExecutor().waitForVaadin();
        return this.driver.manage().logs().get("browser").getAll().stream().filter(logEntry -> logEntry.getLevel().intValue() >= level.intValue()).filter(logEntry -> !logEntry.getMessage().contains("favicon.ico")).collect(Collectors.toList());
    }

    protected void checkLogsForErrors(Predicate<String> acceptableMessagePredicate) {
        this.getLogEntries(Level.WARNING).forEach(logEntry -> {
            if ((Objects.equals(logEntry.getLevel(), Level.SEVERE) || logEntry.getMessage().contains(" 404 ")) && !logEntry.getMessage().contains(WEB_SOCKET_CONNECTION_ERROR_PREFIX) && !acceptableMessagePredicate.test(logEntry.getMessage())) {
                throw new AssertionError((Object)String.format("Received error message in browser log console right after opening the page, message: %s", logEntry));
            }
            LoggerFactory.getLogger((String)TestBenchHelpers.class.getName()).warn("This message in browser log console may be a potential error: '{}'", logEntry);
        });
    }

    protected void checkLogsForErrors() {
        this.checkLogsForErrors(msg -> false);
    }

    protected void waitForDevServer() {
        Object result;
        do {
            this.getCommandExecutor().waitForVaadin();
        } while (Boolean.TRUE.equals(result = this.getCommandExecutor().executeScript("return window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.devServerIsNotLoaded;", new Object[0])));
    }

    private WebElement getShadowRoot(WebElement webComponent) {
        this.waitUntil(driver -> this.getCommandExecutor().executeScript("return arguments[0].shadowRoot", new Object[]{webComponent}) != null);
        WebElement shadowRoot = (WebElement)this.getCommandExecutor().executeScript("return arguments[0].shadowRoot", new Object[]{webComponent});
        Assert.assertNotNull((String)"Could not locate shadowRoot in the element", (Object)shadowRoot);
        return shadowRoot;
    }

    public void blur() {
        this.executeScript("!!document.activeElement ? document.activeElement.blur() : 0", new Object[0]);
    }

    private static class LazyDndSimulationLoad {
        private static final String DND_SCRIPT = LazyDndSimulationLoad.loadDndScript("/dnd-simulation.js");

        private LazyDndSimulationLoad() {
        }

        private static String loadDndScript(String scriptLocation) {
            InputStream stream = TestBenchHelpers.class.getResourceAsStream(scriptLocation);
            try {
                return IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

