/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.ai.formfiller;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.ai.formfiller.ExperimentalFeatureException;
import com.vaadin.flow.ai.formfiller.FormFillerResult;
import com.vaadin.flow.ai.formfiller.services.ChatGPTChatCompletionService;
import com.vaadin.flow.ai.formfiller.services.FormFillerStats;
import com.vaadin.flow.ai.formfiller.services.LLMService;
import com.vaadin.flow.ai.formfiller.utils.ComponentUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormFiller {
    private static final Logger logger;
    private final Component target;
    private final Map<Component, String> componentInstructions;
    private final List<String> contextInstructions;
    ComponentUtils.ComponentsMapping mapping;
    private final LLMService llmService;

    public FormFiller(Component target, Map<Component, String> componentInstructions, List<String> contextInstructions, LLMService llmService) {
        if (!FeatureFlags.get((VaadinContext)VaadinService.getCurrent().getContext()).isEnabled(FeatureFlags.FORM_FILLER_ADDON)) {
            throw new ExperimentalFeatureException();
        }
        this.llmService = llmService;
        this.target = target;
        this.componentInstructions = componentInstructions;
        this.contextInstructions = contextInstructions;
    }

    public FormFiller(Component target, Map<Component, String> componentInstructions, List<String> contextInstructions) {
        this(target, componentInstructions, contextInstructions, new ChatGPTChatCompletionService());
    }

    public FormFiller(Component target, Map<Component, String> componentInstructions) {
        this(target, componentInstructions, new ArrayList<String>(), new ChatGPTChatCompletionService());
    }

    public FormFiller(Component target, List<String> contextInstructions) {
        this(target, new HashMap<Component, String>(), contextInstructions, new ChatGPTChatCompletionService());
    }

    public FormFiller(Component target) {
        this(target, new HashMap<Component, String>(), new ArrayList<String>(), new ChatGPTChatCompletionService());
    }

    public FormFiller(Component target, LLMService llmService) {
        this(target, new HashMap<Component, String>(), new ArrayList<String>(), llmService);
    }

    public FormFillerResult fill(String input) {
        String prompt = "";
        this.mapping = ComponentUtils.createMapping(this.target);
        prompt = this.llmService.getPromptTemplate(input, this.mapping.componentsJSONMap(), this.mapping.componentsTypesJSONMap(), this.componentInstructions, this.contextInstructions);
        String aiResponse = this.llmService.getGeneratedResponse(prompt);
        ComponentUtils.fillComponents(this.mapping.componentInfoList(), this.promptJsonToMapHierarchyValues(aiResponse));
        logger.debug("Generated Prompt: {}", (Object)prompt);
        logger.debug("Generated Components Hierarchy JSON: {}", this.mapping.componentsJSONMap());
        logger.debug("Generated Components Types JSON: {}", this.mapping.componentsTypesJSONMap());
        logger.debug("AI response: " + aiResponse.trim());
        return new FormFillerResult(prompt, aiResponse);
    }

    private Map<String, Object> promptJsonToMapHierarchyValues(String response) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        Map<String, Object> contentMap = new HashMap<String, Object>();
        try {
            contentMap = (Map)objectMapper.readValue(response.trim(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            logger.error("Error parsing AI response to JSON Object: {}", (Object)e.getMessage());
        }
        return contentMap;
    }

    public Map<Component, String> getComponentInstructions() {
        return this.componentInstructions;
    }

    public List<String> getContextInstructions() {
        return this.contextInstructions;
    }

    public ComponentUtils.ComponentsMapping getMapping() {
        return this.mapping;
    }

    static {
        FormFillerStats.report();
        logger = LoggerFactory.getLogger(FormFiller.class);
        logger.warn("The Form Filler Add-on is an experimental feature and it may be removed, altered, or limited to commercial subscribers in future releases.");
    }
}

