/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.ai.formfiller.services;

import com.theokanning.openai.completion.CompletionChoice;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.service.OpenAiService;
import com.vaadin.flow.ai.formfiller.services.LLMService;
import com.vaadin.flow.ai.formfiller.utils.KeysUtils;
import com.vaadin.flow.component.Component;
import java.time.Duration;
import java.util.List;
import java.util.Map;

public class ChatGPTService
extends OpenAiService
implements LLMService {
    private String MODEL = "gpt-3.5-turbo-instruct";
    private Integer MAX_TOKENS = 2048;
    private Double TEMPERATURE = 0.0;
    private Boolean ECHO = false;
    private static Integer TIMEOUT = 60;

    public ChatGPTService() {
        super(KeysUtils.getOpenAiKey(), Duration.ofSeconds(TIMEOUT.intValue()));
    }

    @Override
    public String getPromptTemplate(String input, Map<String, Object> objectMap, Map<String, String> typesMap, Map<Component, String> componentInstructions, List<String> contextInstructions) {
        Object gptRequest = String.format("Based on the user input: '%s', generate a JSON object according to these instructions: Never include duplicate keys, in case of duplicate keys just keep the first occurrence in the response. Generate the JSON object with all keys being double quoted.Fill out null value in the JSON value if the user did not specify a value. Return the result as a JSON object in this format: '%s'. Perform any modification in the response to assure a valid JSON object.", input, objectMap);
        if (!componentInstructions.isEmpty() || !typesMap.isEmpty()) {
            gptRequest = (String)gptRequest + "Some Additional instructions about some of the fields to be filled: ";
            for (Map.Entry<String, String> entry : typesMap.entrySet()) {
                gptRequest = (String)gptRequest + " " + entry.getKey() + ": Format this field as " + entry.getValue() + ".";
            }
            for (Map.Entry entry : componentInstructions.entrySet()) {
                if (!((Component)entry.getKey()).getId().isPresent()) continue;
                gptRequest = (String)gptRequest + " " + (String)((Component)entry.getKey()).getId().get() + ": " + (String)entry.getValue() + ".";
            }
        }
        if (!contextInstructions.isEmpty()) {
            gptRequest = (String)gptRequest + "Additional instructions about the context and desired JSON output response: ";
            for (String string : contextInstructions) {
                gptRequest = (String)gptRequest + " " + string + ".";
            }
        }
        return gptRequest;
    }

    @Override
    public String getGeneratedResponse(String prompt) {
        CompletionRequest completionRequest = CompletionRequest.builder().prompt(prompt).model(this.MODEL).maxTokens(this.MAX_TOKENS).temperature(this.TEMPERATURE).echo(Boolean.valueOf(false)).build();
        CompletionResult completion = this.createCompletion(completionRequest);
        String aiResponse = ((CompletionChoice)completion.getChoices().get(0)).getText();
        return aiResponse;
    }
}

