/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.ai.formfiller.services;

import com.vaadin.flow.internal.UsageStatistics;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormFillerStats {
    private static final String PRODUCT_NAME = "flow/form-filler-addon";
    private static final String PRODUCT_VERSION = "0.1.0";
    private static final Logger LOGGER = LoggerFactory.getLogger(FormFillerStats.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> getVaadinFormVersion() {
        try (InputStream pomProperties = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/pom.xml");){
            if (pomProperties != null) {
                Properties properties = new Properties();
                properties.load(pomProperties);
                Optional<String> optional2 = Optional.of(properties.getProperty("version", PRODUCT_VERSION));
                return optional2;
            }
            Optional<String> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            LOGGER.error("Unable to determine vaadin-form-filler-addon version will use fallback version: {}", (Object)PRODUCT_VERSION, (Object)e);
            return Optional.empty();
        }
    }

    public static void report() {
        UsageStatistics.markAsUsed((String)PRODUCT_NAME, (String)FormFillerStats.getVaadinFormVersion().orElse(PRODUCT_VERSION));
    }
}

