/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator;

import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import dev.hilla.ExplicitNullableTypeChecker;
import dev.hilla.generator.GeneratorUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class GeneratorType {
    private final Type type;
    private final ResolvedType resolvedType;
    private final boolean isResolvable;

    GeneratorType(Type type) {
        this.type = type;
        this.resolvedType = type.resolve();
        this.isResolvable = true;
    }

    GeneratorType(ResolvedType resolvedType) {
        this.type = null;
        this.resolvedType = resolvedType;
        this.isResolvable = true;
    }

    GeneratorType(Type type, ResolvedType resolvedType) {
        this.type = type;
        this.resolvedType = resolvedType;
        this.isResolvable = false;
    }

    boolean hasType() {
        return this.type != null;
    }

    boolean isArray() {
        return this.resolvedType.isArray();
    }

    boolean isBoolean() {
        if (this.resolvedType.isPrimitive()) {
            return this.resolvedType.asPrimitive() == ResolvedPrimitiveType.BOOLEAN;
        }
        return this.isAssignableType(Boolean.class);
    }

    boolean isCollection() {
        return !this.resolvedType.isPrimitive() && (this.isAssignableType(Collection.class) || this.isExactType(Iterable.class));
    }

    boolean isDate() {
        return this.resolvedType.isReferenceType() && this.isAssignableType(Date.class, LocalDate.class);
    }

    boolean isDateTime() {
        return this.resolvedType.isReferenceType() && this.isAssignableType(LocalDateTime.class, Instant.class, LocalTime.class);
    }

    boolean isEnum() {
        return this.isAssignableType(Enum.class);
    }

    boolean isMap() {
        return !this.resolvedType.isPrimitive() && this.isAssignableType(Map.class);
    }

    boolean isNumber() {
        if (this.resolvedType.isPrimitive()) {
            ResolvedPrimitiveType resolvedPrimitiveType = this.resolvedType.asPrimitive();
            return resolvedPrimitiveType != ResolvedPrimitiveType.BOOLEAN && resolvedPrimitiveType != ResolvedPrimitiveType.CHAR;
        }
        return this.isAssignableType(Number.class);
    }

    boolean isOptional() {
        return this.resolvedType.isReferenceType() && this.isAssignableType(Optional.class);
    }

    boolean isPrimitive() {
        return this.resolvedType.isPrimitive();
    }

    boolean isReference() {
        return this.resolvedType.isReferenceType();
    }

    boolean isRequired() {
        return this.isPrimitive() || this.hasType() && ExplicitNullableTypeChecker.isRequired((List<AnnotationExpr>)this.type.getAnnotations());
    }

    boolean isString() {
        if (this.resolvedType.isPrimitive()) {
            return this.resolvedType.asPrimitive() == ResolvedPrimitiveType.CHAR;
        }
        return this.isAssignableType(String.class, Character.class);
    }

    boolean isUnhandled() {
        return this.resolvedType.isReferenceType() && this.resolvedType.asReferenceType().getQualifiedName().startsWith("java.");
    }

    boolean isExactType(Class<?> ... classes) {
        return this.resolvedType.isReferenceType() && this.isType(this.resolvedType.asReferenceType(), classes);
    }

    boolean isAssignableType(Class<?> ... classes) {
        if (!this.resolvedType.isReferenceType()) {
            return false;
        }
        ResolvedReferenceType resolvedReferenceType = this.resolvedType.asReferenceType();
        return this.isType(resolvedReferenceType, classes) || resolvedReferenceType.getAllAncestors().stream().anyMatch(ancestor -> this.isType((ResolvedReferenceType)ancestor, classes));
    }

    ResolvedType asResolvedType() {
        return this.resolvedType;
    }

    Optional<Type> asType() {
        return Optional.ofNullable(this.type);
    }

    GeneratorType getItemType() {
        if (this.hasType()) {
            Type componentType = this.type.asArrayType().getComponentType();
            if (this.isResolvable) {
                return new GeneratorType(componentType);
            }
            return new GeneratorType(componentType, this.resolvedType.asArrayType().getComponentType());
        }
        return new GeneratorType(this.resolvedType.asArrayType().getComponentType());
    }

    List<GeneratorType> getTypeArguments() {
        if (this.hasType()) {
            return this.type.asClassOrInterfaceType().getTypeArguments().map(typeArguments -> {
                if (this.isResolvable) {
                    return typeArguments.stream().map(GeneratorType::new).collect(Collectors.toList());
                }
                List typeParameters = this.resolvedType.asReferenceType().getTypeParametersMap();
                return GeneratorUtils.zip(typeArguments, typeParameters, (argument, parameterPair) -> new GeneratorType((Type)argument, (ResolvedType)parameterPair.b)).collect(Collectors.toList());
            }).orElseGet(this::getTypeArgumentsFallback);
        }
        return this.getTypeArgumentsFallback();
    }

    private List<GeneratorType> getTypeArgumentsFallback() {
        return this.resolvedType.asReferenceType().getTypeParametersMap().stream().filter(Objects::nonNull).map(parameter -> new GeneratorType((ResolvedType)parameter.b)).collect(Collectors.toList());
    }

    private boolean isType(ResolvedReferenceType type, Class<?> ... classes) {
        return Arrays.stream(classes).map(Class::getName).anyMatch(className -> className.equals(type.getQualifiedName()));
    }
}

