/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.declarations.ResolvedEnumConstantDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.github.javaparser.resolution.types.ResolvedType;
import dev.hilla.ExplicitNullableTypeChecker;
import dev.hilla.generator.GeneratorType;
import dev.hilla.generator.GeneratorUtils;
import dev.hilla.generator.OpenAPIObjectGenerator;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaGenerator {
    private final OpenAPIObjectGenerator openApiObjectGenerator;

    SchemaGenerator(OpenAPIObjectGenerator openApiObjectGenerator) {
        this.openApiObjectGenerator = openApiObjectGenerator;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SchemaGenerator.class);
    }

    Schema createSingleSchema(String fullQualifiedName, TypeDeclaration<?> typeDeclaration) {
        Optional<String> description = typeDeclaration.getJavadoc().map(javadoc -> javadoc.getDescription().toText());
        ObjectSchema schema = new ObjectSchema();
        schema.setName(fullQualifiedName);
        description.ifPresent(arg_0 -> ((Schema)schema).setDescription(arg_0));
        Map<String, Schema> properties = this.getPropertiesFromClassDeclaration(typeDeclaration);
        schema.properties(properties);
        List requiredList = properties.entrySet().stream().filter(stringSchemaEntry -> GeneratorUtils.isNotTrue(((Schema)stringSchemaEntry.getValue()).getNullable())).map(Map.Entry::getKey).collect(Collectors.toList());
        properties.values().forEach(propertySchema -> propertySchema.nullable(null));
        schema.setRequired(requiredList);
        return schema;
    }

    Schema toSchema(Type javaType, List<AnnotationExpr> annotations, String description) {
        try {
            ResolvedType mappedType = this.openApiObjectGenerator.toMappedType(javaType);
            GeneratorType generatorType = mappedType != null ? new GeneratorType(mappedType) : new GeneratorType(javaType);
            Schema schema = this.openApiObjectGenerator.parseResolvedTypeToSchema(generatorType, annotations);
            if (GeneratorUtils.isNotBlank(description)) {
                schema.setDescription(description);
            }
            return schema;
        }
        catch (Exception e) {
            SchemaGenerator.getLogger().info(String.format("Can't resolve type '%s' for creating custom OpenAPI Schema. Using the default ObjectSchema instead.", javaType.asString()), (Throwable)e);
            return new ObjectSchema();
        }
    }

    Schema createSingleSchemaFromResolvedType(GeneratorType type) {
        ResolvedReferenceType resolvedReferenceType = type.asResolvedType().asReferenceType();
        if (type.isEnum()) {
            List entries = ((ResolvedReferenceTypeDeclaration)resolvedReferenceType.getTypeDeclaration().orElseThrow(IllegalArgumentException::new)).asEnum().getEnumConstants().stream().map(ResolvedEnumConstantDeclaration::getName).collect(Collectors.toList());
            StringSchema schema = new StringSchema();
            schema.name(resolvedReferenceType.getQualifiedName());
            schema.setEnum(entries);
            return schema;
        }
        Schema schema = new ObjectSchema().name(resolvedReferenceType.getQualifiedName());
        Map<String, Boolean> fieldsOptionalMap = this.getFieldsAndOptionalMap(type);
        List serializableFields = ((ResolvedReferenceTypeDeclaration)resolvedReferenceType.getTypeDeclaration().orElseThrow(IllegalArgumentException::new)).getDeclaredFields().stream().filter(resolvedFieldDeclaration -> fieldsOptionalMap.containsKey(resolvedFieldDeclaration.getName())).collect(Collectors.toList());
        schema.setProperties(new LinkedHashMap());
        for (ResolvedFieldDeclaration resolvedFieldDeclaration2 : serializableFields) {
            String name = resolvedFieldDeclaration2.getName();
            ResolvedType fieldType = resolvedFieldDeclaration2.getType();
            ResolvedType mappedType = this.openApiObjectGenerator.toMappedType(fieldType);
            if (mappedType != null) {
                fieldType = mappedType;
            }
            Schema subtype = this.openApiObjectGenerator.parseResolvedTypeToSchema(new GeneratorType(fieldType)).nullable(null);
            if (!fieldsOptionalMap.get(name).booleanValue()) {
                schema.addRequiredItem(name);
            }
            schema.addProperties(name, subtype);
        }
        return schema;
    }

    private Map<String, Boolean> getFieldsAndOptionalMap(GeneratorType type) {
        ResolvedReferenceType resolvedReferenceType = type.asResolvedType().asReferenceType();
        Optional typeDeclaration = resolvedReferenceType.getTypeDeclaration();
        if (!typeDeclaration.filter(td -> td.isClass() && !td.isAnonymousClass()).isPresent()) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> validFields = new HashMap<String, Boolean>();
        try {
            Class<?> aClass = this.openApiObjectGenerator.getClassFromReflection(type);
            Arrays.stream(aClass.getDeclaredFields()).filter(field -> {
                int modifiers = field.getModifiers();
                return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !field.isAnnotationPresent(JsonIgnore.class);
            }).forEach(field -> validFields.put(field.getName(), !ExplicitNullableTypeChecker.isRequired(field)));
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Can't get list of fields from class '%s'.Please make sure that class '%s' is in your project's compile classpath. As the result, the generated TypeScript file will be empty.", resolvedReferenceType.getQualifiedName(), resolvedReferenceType.getQualifiedName());
            SchemaGenerator.getLogger().info(message);
            SchemaGenerator.getLogger().debug(message, (Throwable)e);
        }
        return validFields;
    }

    private Map<String, Schema> getPropertiesFromClassDeclaration(TypeDeclaration<?> typeDeclaration) {
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        for (FieldDeclaration field : typeDeclaration.getFields()) {
            if (field.isTransient() || field.isStatic() || field.isAnnotationPresent(JsonIgnore.class)) continue;
            Optional<String> fieldDescription = field.getJavadoc().map(javadoc -> javadoc.getDescription().toText());
            field.getVariables().forEach(variableDeclarator -> {
                Schema propertySchema = this.toSchema(variableDeclarator.getType(), (List<AnnotationExpr>)field.getAnnotations(), fieldDescription.orElse(""));
                if (GeneratorUtils.isNotBlank(propertySchema.get$ref())) {
                    ComposedSchema wrapperSchema = new ComposedSchema();
                    wrapperSchema.name(propertySchema.getName());
                    wrapperSchema.addAllOfItem(propertySchema);
                    propertySchema = wrapperSchema;
                }
                this.addFieldAnnotationsToSchema(field, propertySchema);
                properties.put(variableDeclarator.getNameAsString(), propertySchema);
            });
        }
        return properties;
    }

    private void addFieldAnnotationsToSchema(FieldDeclaration field, Schema<?> schema) {
        LinkedHashSet annotations = new LinkedHashSet();
        field.getAnnotations().stream().forEach(annotation -> {
            String str = annotation.toString().replaceFirst("@", "").replace(" = ", ":");
            if (str.contains(":")) {
                str = str.replaceFirst("\\(", "({").replaceFirst("\\)$", "})");
            }
            if ((str = str + (str.contains("(") ? "" : "()")).matches("(Email|Null|NotNull|NotEmpty|NotBlank|AssertTrue|AssertFalse|Negative|NegativeOrZero|Positive|PositiveOrZero|Size|Past|Future|Digits|Min|Max|Pattern|DecimalMin|DecimalMax)\\(.+")) {
                annotations.add(str);
            }
        });
        if (!annotations.isEmpty()) {
            schema.addExtension("x-annotations", annotations.stream().sorted((a, b) -> this.isAnnotationIndicatingRequired((String)a) ? -1 : (this.isAnnotationIndicatingRequired((String)b) ? 1 : a.compareTo((String)b))).collect(Collectors.toList()));
        }
    }

    private boolean isAnnotationIndicatingRequired(String str) {
        return str.matches("(NonNull|NotNull|NotEmpty|NotBlank)\\(.+") || str.matches("Size\\(.+") && Pattern.compile("\\bmin:[^0]").matcher(str).find();
    }
}

