/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator.typescript;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import dev.hilla.EndpointNameChecker;
import dev.hilla.generator.GeneratorUtils;
import dev.hilla.generator.typescript.CodeGeneratorUtils;
import dev.hilla.generator.typescript.ModelGenerator;
import io.swagger.codegen.v3.ClientOptInput;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenResponse;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.DefaultGenerator;
import io.swagger.codegen.v3.generators.typescript.AbstractTypeScriptClientCodegen;
import io.swagger.codegen.v3.generators.util.OpenAPIUtil;
import io.swagger.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerator
extends AbstractTypeScriptClientCodegen {
    static final String IMPORT = "import";
    private static final String EXTENSION_VAADIN_CONNECT_METHOD_NAME = "x-vaadin-connect-method-name";
    private static final String EXTENSION_VAADIN_CONNECT_PARAMETERS = "x-vaadin-connect-parameters";
    private static final String EXTENSION_VAADIN_CONNECT_SERVICE_NAME = "x-vaadin-connect-endpoint-name";
    private static final String EXTENSION_VAADIN_CONNECT_SHOW_TSDOC = "x-vaadin-connect-show-tsdoc";
    private static final String GENERATOR_NAME = "javascript-vaadin-connect";
    private static final String OPERATION = "operation";
    private static final Pattern PATH_REGEX = Pattern.compile("^/([^/{}\n\t]+)/([^/{}\n\t]+)$");
    private static final String VAADIN_CONNECT_CLASS_DESCRIPTION = "vaadinConnectClassDescription";
    private static final String VAADIN_FILE_PATH = "vaadinFilePath";
    private final Logger logger = LoggerFactory.getLogger(CodeGenerator.class);
    private List<Tag> tags;

    public CodeGenerator() {
        this.outputFolder = "target/generated-resources/ts";
        this.apiTemplateFiles.put("TypeScriptApiTemplate.mustache", ".ts");
        this.modelTemplateFiles.put("EntityTemplate.mustache", ".ts");
        this.modelTemplateFiles.put("EntityModelTemplate.mustache", "Model.ts");
        this.templateDir = "dev/hilla/generator";
        this.reservedWords.addAll(EndpointNameChecker.ECMA_SCRIPT_RESERVED_WORDS);
        this.reservedWords.addAll(this.languageSpecificPrimitives);
        this.typeMapping.put("BigDecimal", "number");
        this.typeMapping.put("map", "Map");
        this.typeMapping.put("Map", "Map");
        this.typeMapping.put("DateTime", "string");
        this.typeMapping.put("Date", "string");
    }

    public static Set<File> generateFiles(ClientOptInput input) {
        return new TypescriptCodeGeneratorImpl().opts(input).generate().stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static RuntimeException getGeneratorException(String message) {
        return new RuntimeException(message + " For more information, please checkout the Vaadin TypeScript Generator documentation page at https://vaadin.com/docs/flow/typescript/typescript-endpoints-generator.html.");
    }

    private static boolean isDebugConnectMavenPlugin() {
        return System.getProperty("debugConnectMavenPlugin") != null;
    }

    public void addHandlebarHelpers(Handlebars handlebars) {
        super.addHandlebarHelpers(handlebars);
        handlebars.registerHelper("multiplelines", this.getMultipleLinesHelper());
        handlebars.registerHelper("getClassNameFromImports", this.getClassNameFromImportsHelper());
        handlebars.registerHelper("getModelArguments", ModelGenerator.getModelArgumentsHelper());
        handlebars.registerHelper("getModelFullType", ModelGenerator.getModelFullTypeHelper());
    }

    public String apiFileFolder() {
        return this.outputFolder;
    }

    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    public String escapeReservedWord(String name) {
        return this.reservedWordsMappings().getOrDefault(name, "_" + name);
    }

    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allDefinitions) {
        CodegenModel codegenModel = super.fromModel(name, schema, allDefinitions);
        Set<String> imports = this.collectImportsFromSchema(schema);
        imports.removeIf(type -> type.equals(name));
        codegenModel.setImports(imports);
        return codegenModel;
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, Map<String, Schema> schemas, OpenAPI openAPI) {
        if (!"POST".equalsIgnoreCase(httpMethod)) {
            throw CodeGenerator.getGeneratorException("Code generator only supports POST requests.");
        }
        Matcher matcher = PATH_REGEX.matcher(path);
        if (!matcher.matches()) {
            throw CodeGenerator.getGeneratorException("Path must be in form of \"/<EndpointName>/<MethodName>\".");
        }
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, schemas, openAPI);
        String endpointName = matcher.group(1);
        String methodName = matcher.group(2);
        codegenOperation.getVendorExtensions().put(EXTENSION_VAADIN_CONNECT_METHOD_NAME, methodName);
        codegenOperation.getVendorExtensions().put(EXTENSION_VAADIN_CONNECT_SERVICE_NAME, endpointName);
        this.validateOperationTags(path, httpMethod, operation);
        return codegenOperation;
    }

    public CodegenParameter fromRequestBody(RequestBody body, String name, Schema schema, Map<String, Schema> schemas, Set<String> imports) {
        CodegenParameter codegenParameter = super.fromRequestBody(body, name, schema, schemas, imports);
        Schema requestBodySchema = this.getRequestBodySchema(body);
        if (requestBodySchema != null) {
            imports.addAll(this.collectImportsFromSchema(requestBodySchema));
            List<ParameterInformation> paramsList = this.getParamsList(requestBodySchema);
            codegenParameter.getVendorExtensions().put(EXTENSION_VAADIN_CONNECT_PARAMETERS, paramsList);
        }
        return codegenParameter;
    }

    public String getDefaultTemplateDir() {
        return this.templateDir;
    }

    public String getHelp() {
        return "Generates a Vaadin endpoint wrappers.";
    }

    public String getName() {
        return GENERATOR_NAME;
    }

    public String getSchemaType(Schema schema) {
        if (this.isNullableWrapperSchema(schema) && schema instanceof ComposedSchema) {
            Schema wrappedSchema = (Schema)((ComposedSchema)schema).getAllOf().get(0);
            return super.getSchemaType(wrappedSchema);
        }
        return super.getSchemaType(schema);
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getTypeDeclaration(Schema schema) {
        String optionalSuffix = "";
        if (GeneratorUtils.isTrue(schema.getNullable())) {
            optionalSuffix = " | undefined";
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema inner = arraySchema.getItems();
            return String.format("Array<%s>%s", this.getTypeDeclaration(inner), optionalSuffix);
        }
        if (GeneratorUtils.isNotBlank(schema.get$ref())) {
            return OpenAPIUtil.getSimpleRef((String)schema.get$ref()) + optionalSuffix;
        }
        if (schema.getAdditionalProperties() != null) {
            Schema inner = (Schema)schema.getAdditionalProperties();
            return String.format("Record<string, %s>%s", this.getTypeDeclaration(inner), optionalSuffix);
        }
        if (schema instanceof ComposedSchema) {
            return this.getTypeDeclarationFromComposedSchema((ComposedSchema)schema, optionalSuffix);
        }
        return super.getTypeDeclaration(schema) + optionalSuffix;
    }

    public String modelFileFolder() {
        return this.outputFolder;
    }

    public Map<String, Object> postProcessAllModels(Map<String, Object> processedModels) {
        Map postProcessAllModels = super.postProcessAllModels(processedModels);
        for (Map.Entry modelEntry : postProcessAllModels.entrySet()) {
            Map model = (Map)modelEntry.getValue();
            List imports = (List)model.get("imports");
            this.adjustImportInformationForModel(imports, (String)model.get("classname"));
        }
        this.printDebugMessage(processedModels, "=== All models data ===");
        return postProcessAllModels;
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        String classname = (String)operations.get("classname");
        for (Tag tag : this.tags) {
            if (!tag.getName().equals(classname)) continue;
            objs.put(VAADIN_CONNECT_CLASS_DESCRIPTION, tag.getDescription());
            this.setVaadinFilePath(objs, tag);
            break;
        }
        if (objs.get(VAADIN_CONNECT_CLASS_DESCRIPTION) == null) {
            this.logger.debug("The class '{}' doesn't have JavaDoc or it is invalid. This results in no TsDoc for the generated module '{}'.", (Object)classname, (Object)classname);
        }
        if (operations.get(OPERATION) instanceof List) {
            List codegenOperations = (List)operations.get(OPERATION);
            this.setShouldShowTsDoc(codegenOperations);
        }
        Map postProcessOperations = super.postProcessOperations(objs);
        List imports = (List)objs.get("imports");
        this.adjustImportInformationForEndpoints(imports);
        this.printDebugMessage(postProcessOperations, "=== All operations data ===");
        return postProcessOperations;
    }

    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.processOpenAPI(openAPI);
        List openAPITags = openAPI.getTags();
        this.tags = openAPITags != null ? openAPITags : Collections.emptyList();
    }

    public String toApiName(String name) {
        return this.initialCaps(name);
    }

    public String toEnumVarName(String name, String datatype) {
        return name;
    }

    public String toModelFilename(String name) {
        if (!GeneratorUtils.contains(name, ".")) {
            return super.toModelFilename(name);
        }
        String packageName = GeneratorUtils.substringBeforeLast(name, ".");
        packageName = packageName.replaceAll("\\.", "/");
        String modelName = GeneratorUtils.substringAfterLast(name, ".");
        modelName = super.toModelFilename(modelName);
        return packageName + "/" + modelName;
    }

    public String toModelName(String name) {
        return name;
    }

    public void addImport(CodegenModel m, String type) {
        if (!Objects.equals(m.getName(), type)) {
            super.addImport(m, type);
        }
    }

    protected String getTemplateDir() {
        return this.templateDir;
    }

    private void adjustImportInformation(List<Map<String, Object>> imports, String relativePathFromGeneratedFolderToCurrentFile) {
        HashSet<String> usedNames = new HashSet<String>();
        imports.sort((o1, o2) -> GeneratorUtils.compare((String)o1.get(IMPORT), (String)o2.get(IMPORT)));
        for (Map<String, Object> anImport : imports) {
            String importQualifiedName = (String)anImport.get(IMPORT);
            String className = CodeGeneratorUtils.getSimpleNameFromQualifiedName(importQualifiedName);
            if (usedNames.contains(className)) {
                String importAs = this.getUniqueNameFromQualifiedName(usedNames, importQualifiedName);
                anImport.put("importAs", importAs);
                usedNames.add(importAs);
            } else {
                usedNames.add(className);
            }
            anImport.put("className", className);
            String importPath = this.convertQualifiedNameToModelPath(importQualifiedName);
            String relativizedPath = Paths.get(relativePathFromGeneratedFolderToCurrentFile, new String[0]).relativize(Paths.get(importPath, new String[0])).toString();
            relativizedPath = this.relativePathToNodeImport(relativizedPath);
            anImport.put("importPath", relativizedPath);
        }
    }

    private void adjustImportInformationForEndpoints(List<Map<String, Object>> imports) {
        this.adjustImportInformation(imports, ".");
    }

    private void adjustImportInformationForModel(List<Map<String, Object>> imports, String qualifiedNameForRelative) {
        String modelFilePath = this.convertQualifiedNameToModelPath(qualifiedNameForRelative);
        modelFilePath = GeneratorUtils.substringBeforeLast(modelFilePath, "/");
        this.adjustImportInformation(imports, modelFilePath);
    }

    private Set<String> collectImportsFromSchema(Schema schema) {
        HashSet<String> imports = new HashSet<String>();
        if (GeneratorUtils.isNotBlank(schema.get$ref())) {
            imports.add(OpenAPIUtil.getSimpleRef((String)schema.get$ref()));
        }
        if (schema instanceof ArraySchema) {
            imports.addAll(this.collectImportsFromSchema(((ArraySchema)schema).getItems()));
        } else if (schema instanceof MapSchema || schema.getAdditionalProperties() instanceof Schema) {
            imports.addAll(this.collectImportsFromSchema((Schema)schema.getAdditionalProperties()));
        } else if (schema instanceof ComposedSchema) {
            for (Schema child : ((ComposedSchema)schema).getAllOf()) {
                imports.addAll(this.collectImportsFromSchema(child));
            }
        }
        if (schema.getProperties() != null) {
            schema.getProperties().values().forEach(o -> imports.addAll(this.collectImportsFromSchema((Schema)o)));
        }
        return imports;
    }

    private String convertQualifiedNameToModelPath(String qualifiedName) {
        return "./" + GeneratorUtils.replaceChars(qualifiedName, '.', '/');
    }

    private Helper<String> getClassNameFromImportsHelper() {
        return (className, options) -> CodeGeneratorUtils.getSimpleNameFromImports(className, (List)options.param(0));
    }

    private String getDescriptionFromParameterExtension(String paramName, Schema requestSchema) {
        if (requestSchema.getExtensions() == null) {
            return "";
        }
        Map paramDescription = (Map)requestSchema.getExtensions().get("x-vaadin-parameters-description");
        return paramDescription.getOrDefault(paramName, "");
    }

    private Helper<String> getMultipleLinesHelper() {
        return (context, options) -> {
            Options.Buffer buffer = options.buffer();
            String[] lines = context.split("\n", -1);
            Context parent = options.context;
            Template fn = options.fn;
            for (String line : lines) {
                buffer.append(options.apply(fn, parent.combine("@line", (Object)line)));
            }
            return buffer;
        };
    }

    private List<ParameterInformation> getParamsList(Schema requestSchema) {
        Map properties = requestSchema.getProperties();
        ArrayList<ParameterInformation> paramsList = new ArrayList<ParameterInformation>();
        List requiredParams = requestSchema.getRequired() != null ? requestSchema.getRequired() : Collections.emptyList();
        for (Map.Entry entry : properties.entrySet()) {
            String name = (String)entry.getKey();
            boolean isRequired = requiredParams.contains(name);
            name = this.isReservedWord(name) ? this.escapeReservedWord(name) : name;
            String type = this.getTypeDeclaration((Schema)entry.getValue());
            String description = ((Schema)entry.getValue()).getDescription();
            if (GeneratorUtils.isBlank(description)) {
                description = this.getDescriptionFromParameterExtension(name, requestSchema);
            }
            ParameterInformation parameterInformation = new ParameterInformation(name, isRequired, type, description);
            paramsList.add(parameterInformation);
        }
        return paramsList;
    }

    private Schema getRequestBodySchema(RequestBody body) {
        Content content = body.getContent();
        if (content == null) {
            return null;
        }
        MediaType mediaType = (MediaType)content.get((Object)"application/json");
        if (mediaType != null && mediaType.getSchema() != null) {
            return mediaType.getSchema();
        }
        return null;
    }

    private String getTypeDeclarationFromComposedSchema(ComposedSchema composedSchema, String optionalSuffix) {
        if (composedSchema.getAllOf() != null && composedSchema.getAllOf().size() == 1) {
            return this.getTypeDeclaration((Schema)composedSchema.getAllOf().get(0)) + optionalSuffix;
        }
        String unknownComposedSchema = Json.pretty((Object)composedSchema);
        this.logger.debug("Unknown ComposedSchema: {}", (Object)unknownComposedSchema);
        return "any";
    }

    private String getUniqueNameFromQualifiedName(Set<String> usedNames, String qualifiedName) {
        String[] packageSegments = qualifiedName == null ? null : qualifiedName.split("\\.");
        StringBuilder classNameBuilder = new StringBuilder();
        String newClassName = "";
        if (packageSegments != null && packageSegments.length > 1) {
            for (int i = packageSegments.length - 1; i >= 0; --i) {
                classNameBuilder.insert(0, GeneratorUtils.capitalize(packageSegments[i]));
                newClassName = classNameBuilder.toString();
                if (usedNames.contains(newClassName)) continue;
                return newClassName;
            }
        } else {
            newClassName = qualifiedName;
        }
        int counter = 1;
        while (usedNames.contains(newClassName)) {
            newClassName = qualifiedName + counter;
            ++counter;
        }
        return newClassName;
    }

    private boolean hasParameterDescription(CodegenOperation coop) {
        for (CodegenParameter bodyParam : coop.getBodyParams()) {
            List parametersList = (List)bodyParam.getVendorExtensions().get(EXTENSION_VAADIN_CONNECT_PARAMETERS);
            if (parametersList == null || !parametersList.stream().anyMatch(parameterInformation -> GeneratorUtils.isNotBlank(parameterInformation.getDescription()))) continue;
            return true;
        }
        return false;
    }

    private boolean hasResponseDescription(CodegenOperation coop) {
        for (CodegenResponse response : coop.getResponses()) {
            if (!GeneratorUtils.isNotBlank(response.getMessage())) continue;
            return true;
        }
        return false;
    }

    private boolean isNullOrEmptyList(List list) {
        return list == null || list.isEmpty();
    }

    private boolean isNullableWrapperSchema(Schema schema) {
        if (!(schema instanceof ComposedSchema)) {
            return false;
        }
        boolean hasOnlyOneSchemaInAllOf = ((ComposedSchema)schema).getAllOf() != null && ((ComposedSchema)schema).getAllOf().size() == 1;
        boolean hasNoOneOfAndAnyOf = this.isNullOrEmptyList(((ComposedSchema)schema).getOneOf()) && this.isNullOrEmptyList(((ComposedSchema)schema).getAnyOf());
        return hasOnlyOneSchemaInAllOf && hasNoOneOfAndAnyOf;
    }

    private void printDebugMessage(Object data, String message) {
        if (CodeGenerator.isDebugConnectMavenPlugin()) {
            this.logger.info(message);
            Json.prettyPrint((Object)data);
        }
    }

    private String relativePathToNodeImport(String relativePath) {
        relativePath = relativePath.replace("\\", "/");
        return relativePath.replaceFirst("^(?!(\\./|\\.|/))", "./");
    }

    private void setShouldShowTsDoc(List<CodegenOperation> operations) {
        for (CodegenOperation coop : operations) {
            boolean hasDescription = GeneratorUtils.isNotBlank(coop.getNotes());
            boolean hasParameter = this.hasParameterDescription(coop);
            boolean hasResponseDescription = this.hasResponseDescription(coop);
            if (!hasDescription && !hasParameter && !hasResponseDescription) continue;
            coop.getVendorExtensions().put(EXTENSION_VAADIN_CONNECT_SHOW_TSDOC, true);
        }
    }

    private void setVaadinFilePath(Map<String, Object> objs, Tag tag) {
        if (tag.getExtensions() != null && tag.getExtensions().get("x-vaadin-file-path") != null) {
            objs.put(VAADIN_FILE_PATH, tag.getExtensions().get("x-vaadin-file-path"));
        }
    }

    private void validateOperationTags(String path, String httpMethod, Operation operation) {
        List operationTags = operation.getTags();
        if (operationTags == null || operationTags.isEmpty()) {
            this.logger.warn("The '{}' operation with path '{}' does not have any tag. The generated method will be included in 'Default' Endpoint.", (Object)httpMethod, (Object)path);
        } else if (operationTags.size() > 1) {
            String fileList = String.join((CharSequence)", ", operationTags);
            this.logger.warn("The '{}' operation with path '{}' contains multiple tags. The generated method will be included in classes: '{}'.", new Object[]{httpMethod, path, fileList});
        }
    }

    static class TypescriptCodeGeneratorImpl
    extends DefaultGenerator {
        TypescriptCodeGeneratorImpl() {
        }

        public File writeToFile(String filename, String contents) throws IOException {
            if (filename.endsWith(".ts")) {
                return super.writeToFile(filename, contents);
            }
            return null;
        }
    }

    private static class ParameterInformation {
        private final String description;
        private final boolean isRequired;
        private final String name;
        private final String type;

        ParameterInformation(String name, boolean isRequired, String type, String description) {
            this.name = name;
            this.isRequired = isRequired;
            this.type = type;
            this.description = description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterInformation that = (ParameterInformation)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.description, that.description);
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.description);
        }

        public boolean isRequired() {
            return this.isRequired;
        }
    }
}

