/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import dev.hilla.Endpoint;
import dev.hilla.EndpointControllerConfiguration;
import dev.hilla.EndpointInvocationException;
import dev.hilla.EndpointInvoker;
import dev.hilla.EndpointProperties;
import dev.hilla.EndpointRegistry;
import dev.hilla.auth.CsrfChecker;
import dev.hilla.exception.EndpointException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Import(value={EndpointControllerConfiguration.class, EndpointProperties.class})
@NpmPackage.Container(value={@NpmPackage(value="@hilla/frontend", version="1.1.0"), @NpmPackage(value="@hilla/form", version="1.1.0")})
public class EndpointController {
    static final String ENDPOINT_METHODS = "/{endpoint}/{method}";
    public static final String VAADIN_ENDPOINT_MAPPER_BEAN_QUALIFIER = "vaadinEndpointMapper";
    EndpointRegistry endpointRegistry;
    private CsrfChecker csrfChecker;
    private EndpointInvoker endpointInvoker;

    public EndpointController(ApplicationContext context, EndpointRegistry endpointRegistry, EndpointInvoker endpointInvoker, CsrfChecker csrfChecker) {
        this.endpointInvoker = endpointInvoker;
        this.csrfChecker = csrfChecker;
        this.endpointRegistry = endpointRegistry;
        context.getBeansWithAnnotation(Endpoint.class).forEach((name, endpointBean) -> endpointRegistry.registerEndpoint(endpointBean));
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(EndpointController.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(path={"/{endpoint}/{method}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> serveEndpoint(@PathVariable(value="endpoint") String endpointName, @PathVariable(value="method") String methodName, @RequestBody(required=false) ObjectNode body, HttpServletRequest request) {
        EndpointController.getLogger().debug("Endpoint: {}, method: {}, request body: {}", new Object[]{endpointName, methodName, body});
        if (!this.csrfChecker.validateCsrfTokenInRequest(request)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)this.endpointInvoker.createResponseErrorObject("Access denied"));
        }
        try {
            VaadinServletService service = (VaadinServletService)VaadinService.getCurrent();
            CurrentInstance.set(VaadinRequest.class, (Object)new VaadinServletRequest(request, service));
            Object returnValue = this.endpointInvoker.invoke(endpointName, methodName, body, request.getUserPrincipal(), arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
            try {
                ResponseEntity responseEntity = ResponseEntity.ok((Object)this.endpointInvoker.writeValueAsString(returnValue));
                return responseEntity;
            }
            catch (JsonProcessingException e) {
                ResponseEntity responseEntity;
                try {
                    String errorMessage = String.format("Failed to serialize endpoint '%s' method '%s' response. Double check method's return type or specify a custom mapper bean with qualifier '%s'", endpointName, methodName, VAADIN_ENDPOINT_MAPPER_BEAN_QUALIFIER);
                    EndpointController.getLogger().error(errorMessage, (Throwable)e);
                    throw new EndpointInvocationException.EndpointInternalException(errorMessage);
                }
                catch (EndpointException e2) {
                    try {
                        returnValue = ResponseEntity.badRequest().body((Object)this.endpointInvoker.createResponseErrorObject(e2.getSerializationData()));
                        return returnValue;
                    }
                    catch (JsonProcessingException ee) {
                        String errorMessage = String.format("Failed to serialize error object for endpoint exception. ", new Object[0]);
                        EndpointController.getLogger().error(errorMessage, (Throwable)e2);
                        ResponseEntity responseEntity2 = ResponseEntity.internalServerError().body((Object)errorMessage);
                        return responseEntity2;
                    }
                }
                catch (EndpointInvocationException.EndpointNotFoundException e3) {
                    responseEntity = ResponseEntity.notFound().build();
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointAccessDeniedException e4) {
                    responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)this.endpointInvoker.createResponseErrorObject(e4.getMessage()));
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointBadRequestException e5) {
                    responseEntity = ResponseEntity.badRequest().body((Object)this.endpointInvoker.createResponseErrorObject(e5.getMessage()));
                    return responseEntity;
                }
                catch (EndpointInvocationException.EndpointInternalException e6) {
                    responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.endpointInvoker.createResponseErrorObject(e6.getMessage()));
                    return responseEntity;
                }
            }
        }
        finally {
            CurrentInstance.set(VaadinRequest.class, null);
        }
    }
}

