/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.push;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.hilla.ConditionalOnFeatureFlag;
import dev.hilla.push.PushMessageHandler;
import dev.hilla.push.messages.fromclient.AbstractServerMessage;
import dev.hilla.push.messages.toclient.AbstractClientMessage;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoServer;
import io.socket.socketio.server.SocketIoSocket;
import java.util.function.Consumer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnFeatureFlag(value="hillaPush")
public class SocketIoHandler {
    public SocketIoHandler(SocketIoServer socketIoServer, ObjectMapper objectMapper, PushMessageHandler pushMessageHandler) {
        SocketIoNamespace hillaNamespace = socketIoServer.namespace("hilla");
        hillaNamespace.on("connection", event -> {
            SocketIoSocket socket = (SocketIoSocket)event[0];
            pushMessageHandler.handleBrowserConnect(socket.getId());
            Consumer<AbstractClientMessage> sender = message -> {
                try {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Sending push message to the client: " + message);
                    }
                    socket.send("message", new Object[]{objectMapper.writeValueAsString(message)});
                }
                catch (JsonProcessingException | IllegalArgumentException e1) {
                    this.getLogger().warn("Unexpected problem when sending push message", e1);
                }
            };
            socket.on("message", messageEvent -> {
                JSONObject json = (JSONObject)messageEvent[0];
                try {
                    AbstractServerMessage message = (AbstractServerMessage)objectMapper.readValue(json.toString(), AbstractServerMessage.class);
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Received push message from the client: " + message);
                    }
                    pushMessageHandler.handleMessage(socket.getId(), message, sender);
                }
                catch (JsonProcessingException e1) {
                    this.getLogger().warn("Unexpected problem when receiving push message", (Throwable)e1);
                }
            });
            socket.on("disconnect", ev -> pushMessageHandler.handleBrowserDisconnect(socket.getId()));
        });
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

