/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.startup;

import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import dev.hilla.Endpoint;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={Endpoint.class})
public class EndpointsValidator
implements ClassLoaderAwareServletContainerInitializer,
Serializable {
    private String classToCheck = "org.springframework.boot.autoconfigure.jackson.JacksonProperties";

    public void process(Set<Class<?>> classSet, ServletContext servletContext) throws ServletException {
        if (classSet == null) {
            return;
        }
        ClassFinder.DefaultClassFinder finder = new ClassFinder.DefaultClassFinder(classSet);
        Set endpoints = finder.getAnnotatedClasses(Endpoint.class);
        if (!endpoints.isEmpty()) {
            try {
                finder.loadClass(this.classToCheck);
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("ERROR: Vaadin endpoints only work for Spring enabled projects.\nThis is not a spring application but there are Vaadin endpoints in these classes: " + endpoints.stream().map(Class::getName).collect(Collectors.joining("\n    - ")), (Throwable)e);
            }
        }
    }

    void setClassToCheck(String className) {
        this.classToCheck = className;
    }
}

