/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator;

import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.resolution.declarations.ResolvedEnumConstantDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import dev.hilla.ExplicitNullableTypeChecker;
import dev.hilla.generator.GeneratorType;
import dev.hilla.generator.GeneratorUtils;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class SchemaResolver {
    private static final String SCHEMA_REF_PREFIX = "#/components/schemas/";
    private final Map<String, GeneratorType> usedTypes;
    private final GeneratorType type;
    private final List<AnnotationExpr> nodeAnnotations;

    SchemaResolver(GeneratorType type, Map<String, GeneratorType> usedTypes) {
        this.type = type;
        this.nodeAnnotations = null;
        this.usedTypes = usedTypes;
    }

    SchemaResolver(GeneratorType type, List<AnnotationExpr> nodeAnnotations, Map<String, GeneratorType> usedTypes) {
        this.type = type;
        this.nodeAnnotations = nodeAnnotations;
        this.usedTypes = usedTypes;
    }

    static String getFullQualifiedNameRef(String qualifiedName) {
        return SCHEMA_REF_PREFIX + qualifiedName;
    }

    static String getSimpleRef(String ref) {
        if (GeneratorUtils.contains(ref, SCHEMA_REF_PREFIX)) {
            return GeneratorUtils.substringAfter(ref, SCHEMA_REF_PREFIX);
        }
        return ref;
    }

    private static Schema createNullableWrapper(Schema nestedTypeSchema, boolean shouldBeNullable) {
        if (!shouldBeNullable) {
            return nestedTypeSchema;
        }
        if (nestedTypeSchema.get$ref() == null) {
            nestedTypeSchema.setNullable(Boolean.valueOf(true));
            return nestedTypeSchema;
        }
        ComposedSchema nullableSchema = new ComposedSchema();
        nullableSchema.setNullable(Boolean.valueOf(true));
        nullableSchema.setAllOf(Collections.singletonList(nestedTypeSchema));
        return nullableSchema;
    }

    Schema resolve() {
        if (this.type.isArray()) {
            return this.createNullableWrapper(this.createArraySchema());
        }
        if (this.type.isNumber()) {
            return this.createNullableWrapper((Schema)new NumberSchema());
        }
        if (this.type.isString()) {
            return this.createNullableWrapper((Schema)new StringSchema());
        }
        if (this.type.isCollection()) {
            return this.createNullableWrapper(this.createCollectionSchema());
        }
        if (this.type.isBoolean()) {
            return this.createNullableWrapper((Schema)new BooleanSchema());
        }
        if (this.type.isMap()) {
            return this.createNullableWrapper(this.createMapSchema());
        }
        if (this.type.isDate()) {
            return this.createNullableWrapper((Schema)new DateSchema());
        }
        if (this.type.isDateTime()) {
            return this.createNullableWrapper((Schema)new DateTimeSchema());
        }
        if (this.type.isOptional()) {
            return this.createOptionalSchema();
        }
        if (this.type.isUnhandled()) {
            return this.createNullableWrapper((Schema)new ObjectSchema());
        }
        if (this.type.isEnum()) {
            return this.createNullableWrapper(this.createEnumTypeSchema());
        }
        if (this.type.isFlux() || this.type.isEndpointSubscription()) {
            return this.createNullableWrapper(this.createFluxSchema());
        }
        return this.createNullableWrapper(this.createUserBeanSchema());
    }

    private Schema createArraySchema() {
        ArraySchema array = new ArraySchema();
        array.items(new SchemaResolver(this.type.getItemType(), this.usedTypes).resolve());
        return array;
    }

    private Schema createCollectionSchema() {
        ArraySchema array = new ArraySchema();
        List<GeneratorType> typeArguments = this.type.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            array.items(new SchemaResolver(typeArguments.get(0), this.usedTypes).resolve());
        }
        return array;
    }

    private Schema createOptionalSchema() {
        return this.createNullableWrapper(new SchemaResolver(this.type.getTypeArguments().get(0), this.usedTypes).resolve());
    }

    private Schema createNullableWrapper(Schema nestedTypeSchema) {
        return SchemaResolver.createNullableWrapper(nestedTypeSchema, !this.isRequired());
    }

    private Schema createMapSchema() {
        MapSchema mapSchema = new MapSchema();
        List<GeneratorType> typeArguments = this.type.getTypeArguments();
        if (typeArguments.size() == 2) {
            mapSchema.additionalProperties((Object)new SchemaResolver(typeArguments.get(1), this.usedTypes).resolve());
        }
        return mapSchema;
    }

    private Schema createEnumTypeSchema() {
        ResolvedReferenceType resolvedReferenceType = this.type.asResolvedType().asReferenceType();
        List entries = ((ResolvedReferenceTypeDeclaration)resolvedReferenceType.getTypeDeclaration().orElseThrow(IllegalArgumentException::new)).asEnum().getEnumConstants().stream().map(ResolvedEnumConstantDeclaration::getName).collect(Collectors.toList());
        String qualifiedName = resolvedReferenceType.getQualifiedName();
        this.usedTypes.put(qualifiedName, this.type);
        StringSchema schema = new StringSchema();
        schema.name(qualifiedName);
        schema.setEnum(entries);
        schema.$ref(SchemaResolver.getFullQualifiedNameRef(qualifiedName));
        return schema;
    }

    private Schema createUserBeanSchema() {
        if (this.type.isReference()) {
            ResolvedReferenceType resolvedReferenceType = this.type.asResolvedType().asReferenceType();
            String qualifiedName = resolvedReferenceType.getQualifiedName();
            this.usedTypes.put(qualifiedName, this.type);
            return new ObjectSchema().name(qualifiedName).$ref(SchemaResolver.getFullQualifiedNameRef(qualifiedName));
        }
        return new ObjectSchema();
    }

    private Schema createFluxSchema() {
        Schema subTypeSchema = new SchemaResolver(this.type.getTypeArguments().get(0), this.usedTypes).resolve();
        ArraySchema arr = new ArraySchema();
        arr.setItems(subTypeSchema);
        arr.addExtension("x-flux", (Object)true);
        return arr;
    }

    private boolean isRequired() {
        return this.nodeAnnotations != null && ExplicitNullableTypeChecker.isRequired(this.nodeAnnotations) || this.type.isRequired();
    }
}

