/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.connect;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.internal.CurrentInstance;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinServletService;
import com.vaadin.flow.server.connect.Endpoint;
import com.vaadin.flow.server.connect.EndpointNameChecker;
import com.vaadin.flow.server.connect.ExplicitNullableTypeChecker;
import com.vaadin.flow.server.connect.VaadinConnectControllerConfiguration;
import com.vaadin.flow.server.connect.VaadinEndpointProperties;
import com.vaadin.flow.server.connect.auth.VaadinConnectAccessChecker;
import com.vaadin.flow.server.connect.exception.EndpointException;
import com.vaadin.flow.server.connect.exception.EndpointValidationException;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Import(value={VaadinConnectControllerConfiguration.class, VaadinEndpointProperties.class})
@ConditionalOnBean(annotation={Endpoint.class})
public class VaadinConnectController {
    public static final String VAADIN_ENDPOINT_MAPPER_BEAN_QUALIFIER = "vaadinEndpointMapper";
    final Map<String, VaadinEndpointData> vaadinEndpoints = new HashMap<String, VaadinEndpointData>();
    private final ObjectMapper vaadinEndpointMapper;
    private final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private final ExplicitNullableTypeChecker explicitNullableTypeChecker;
    private final ApplicationContext applicationContext;

    public VaadinConnectController(@Autowired(required=false) @Qualifier(value="vaadinEndpointMapper") ObjectMapper vaadinEndpointMapper, EndpointNameChecker endpointNameChecker, ExplicitNullableTypeChecker explicitNullableTypeChecker, ApplicationContext context) {
        this.applicationContext = context;
        this.vaadinEndpointMapper = vaadinEndpointMapper != null ? vaadinEndpointMapper : this.createVaadinConnectObjectMapper(context);
        this.explicitNullableTypeChecker = explicitNullableTypeChecker;
        context.getBeansWithAnnotation(Endpoint.class).forEach((name, endpointBean) -> this.validateEndpointBean(endpointNameChecker, (String)name, endpointBean));
    }

    private ObjectMapper createVaadinConnectObjectMapper(ApplicationContext context) {
        Jackson2ObjectMapperBuilder builder = (Jackson2ObjectMapperBuilder)context.getBean(Jackson2ObjectMapperBuilder.class);
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        JacksonProperties jacksonProperties = (JacksonProperties)context.getBean(JacksonProperties.class);
        if (jacksonProperties.getVisibility().isEmpty()) {
            objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        }
        return objectMapper;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(VaadinConnectController.class);
    }

    void validateEndpointBean(EndpointNameChecker endpointNameChecker, String name, Object endpointBean) {
        Class beanType = ClassUtils.getUserClass(endpointBean.getClass());
        String endpointName = Optional.ofNullable(beanType.getAnnotation(Endpoint.class)).map(Endpoint::value).filter(value -> !value.isEmpty()).orElse(beanType.getSimpleName());
        if (endpointName.isEmpty()) {
            throw new IllegalStateException(String.format("A bean with name '%s' and type '%s' is annotated with '%s' annotation but is an anonymous class hence has no name. ", name, beanType, Endpoint.class) + String.format("Either modify the bean declaration so that it is not an anonymous class or specify an endpoint name in the '%s' annotation", Endpoint.class));
        }
        String validationError = endpointNameChecker.check(endpointName);
        if (validationError != null) {
            throw new IllegalStateException(String.format("Endpoint name '%s' is invalid, reason: '%s'", endpointName, validationError));
        }
        AccessibleObject[] endpointPublicMethods = beanType.getMethods();
        AccessibleObject.setAccessible(endpointPublicMethods, true);
        this.vaadinEndpoints.put(endpointName.toLowerCase(Locale.ENGLISH), new VaadinEndpointData(endpointBean, (Method[])endpointPublicMethods));
    }

    @PostMapping(path={"/{endpoint}/{method}"}, produces={"application/json;charset=UTF-8"})
    public ResponseEntity<String> serveEndpoint(@PathVariable(value="endpoint") String endpointName, @PathVariable(value="method") String methodName, @RequestBody(required=false) ObjectNode body, HttpServletRequest request) {
        VaadinConnectController.getLogger().debug("Endpoint: {}, method: {}, request body: {}", new Object[]{endpointName, methodName, body});
        VaadinEndpointData vaadinEndpointData = this.vaadinEndpoints.get(endpointName.toLowerCase(Locale.ENGLISH));
        if (vaadinEndpointData == null) {
            VaadinConnectController.getLogger().debug("Endpoint '{}' not found", (Object)endpointName);
            return ResponseEntity.notFound().build();
        }
        Method methodToInvoke = vaadinEndpointData.getMethod(methodName.toLowerCase(Locale.ENGLISH)).orElse(null);
        if (methodToInvoke == null) {
            VaadinConnectController.getLogger().debug("Method '{}' not found in endpoint '{}'", (Object)methodName, (Object)endpointName);
            return ResponseEntity.notFound().build();
        }
        try {
            VaadinServletService service = (VaadinServletService)VaadinService.getCurrent();
            CurrentInstance.set(VaadinRequest.class, (Object)new VaadinServletRequest(request, service));
            ResponseEntity<String> responseEntity = this.invokeVaadinEndpointMethod(endpointName, methodName, methodToInvoke, body, vaadinEndpointData, request);
            return responseEntity;
        }
        catch (JsonProcessingException e) {
            String errorMessage = String.format("Failed to serialize endpoint '%s' method '%s' response. Double check method's return type or specify a custom mapper bean with qualifier '%s'", endpointName, methodName, VAADIN_ENDPOINT_MAPPER_BEAN_QUALIFIER);
            VaadinConnectController.getLogger().error(errorMessage, (Throwable)e);
            try {
                ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.createResponseErrorObject(errorMessage));
                return responseEntity;
            }
            catch (JsonProcessingException unexpected) {
                throw new IllegalStateException(String.format("Unexpected: Failed to serialize a plain Java string '%s' into a JSON. Double check the provided mapper's configuration.", errorMessage), unexpected);
            }
        }
        finally {
            CurrentInstance.set(VaadinRequest.class, null);
        }
    }

    private ResponseEntity<String> invokeVaadinEndpointMethod(String endpointName, String methodName, Method methodToInvoke, ObjectNode body, VaadinEndpointData vaadinEndpointData, HttpServletRequest request) throws JsonProcessingException {
        Object returnValue;
        Object[] vaadinEndpointParameters;
        VaadinConnectAccessChecker accessChecker = this.getAccessChecker(request.getServletContext());
        String checkError = accessChecker.check(methodToInvoke, request);
        if (checkError != null) {
            return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body((Object)this.createResponseErrorObject(String.format("Endpoint '%s' method '%s' request cannot be accessed, reason: '%s'", endpointName, methodName, checkError)));
        }
        Map<String, JsonNode> requestParameters = this.getRequestParameters(body);
        Type[] javaParameters = this.getJavaParameters(methodToInvoke, ClassUtils.getUserClass((Object)vaadinEndpointData.vaadinEndpointObject));
        if (javaParameters.length != requestParameters.size()) {
            return ResponseEntity.badRequest().body((Object)this.createResponseErrorObject(String.format("Incorrect number of parameters for endpoint '%s' method '%s', expected: %s, got: %s", endpointName, methodName, javaParameters.length, requestParameters.size())));
        }
        try {
            vaadinEndpointParameters = this.getVaadinEndpointParameters(requestParameters, javaParameters, methodName, endpointName);
        }
        catch (EndpointValidationException e) {
            VaadinConnectController.getLogger().debug("Endpoint '{}' method '{}' received invalid response", new Object[]{endpointName, methodName, e});
            return ResponseEntity.badRequest().body((Object)this.vaadinEndpointMapper.writeValueAsString(e.getSerializationData()));
        }
        Set methodParameterConstraintViolations = this.validator.forExecutables().validateParameters(vaadinEndpointData.getEndpointObject(), methodToInvoke, vaadinEndpointParameters, new Class[0]);
        if (!methodParameterConstraintViolations.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)this.vaadinEndpointMapper.writeValueAsString(new EndpointValidationException(String.format("Validation error in endpoint '%s' method '%s'", endpointName, methodName), this.createMethodValidationErrors(methodParameterConstraintViolations)).getSerializationData()));
        }
        try {
            returnValue = methodToInvoke.invoke(vaadinEndpointData.getEndpointObject(), vaadinEndpointParameters);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = String.format("Received incorrect arguments for endpoint '%s' method '%s'. Expected parameter types (and their order) are: '[%s]'", endpointName, methodName, this.listMethodParameterTypes(javaParameters));
            VaadinConnectController.getLogger().debug(errorMessage, (Throwable)e);
            return ResponseEntity.badRequest().body((Object)this.createResponseErrorObject(errorMessage));
        }
        catch (IllegalAccessException e) {
            String errorMessage = String.format("Endpoint '%s' method '%s' access failure", endpointName, methodName);
            VaadinConnectController.getLogger().error(errorMessage, (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.createResponseErrorObject(errorMessage));
        }
        catch (InvocationTargetException e) {
            return this.handleMethodExecutionError(endpointName, methodName, e);
        }
        String implicitNullError = this.explicitNullableTypeChecker.checkValueForAnnotatedElement(returnValue, methodToInvoke);
        if (implicitNullError != null) {
            EndpointException returnValueException = new EndpointException(String.format("Unexpected return value in endpoint '%s' method '%s'. %s", endpointName, methodName, implicitNullError));
            VaadinConnectController.getLogger().error(returnValueException.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.vaadinEndpointMapper.writeValueAsString(returnValueException.getSerializationData()));
        }
        Set returnValueConstraintViolations = this.validator.forExecutables().validateReturnValue(vaadinEndpointData.getEndpointObject(), methodToInvoke, returnValue, new Class[0]);
        if (!returnValueConstraintViolations.isEmpty()) {
            VaadinConnectController.getLogger().error("Endpoint '{}' method '{}' had returned a value that has validation errors: '{}', this might cause bugs on the client side. Fix the method implementation.", new Object[]{endpointName, methodName, returnValueConstraintViolations});
        }
        return ResponseEntity.ok((Object)this.vaadinEndpointMapper.writeValueAsString(returnValue));
    }

    private Type[] getJavaParameters(Method methodToInvoke, Type classType) {
        return (Type[])Stream.of(GenericTypeReflector.getExactParameterTypes((Method)methodToInvoke, (Type)classType)).toArray(Type[]::new);
    }

    private ResponseEntity<String> handleMethodExecutionError(String endpointName, String methodName, InvocationTargetException e) throws JsonProcessingException {
        if (EndpointException.class.isAssignableFrom(e.getCause().getClass())) {
            EndpointException endpointException = (EndpointException)e.getCause();
            VaadinConnectController.getLogger().debug("Endpoint '{}' method '{}' aborted the execution", new Object[]{endpointName, methodName, endpointException});
            return ResponseEntity.badRequest().body((Object)this.vaadinEndpointMapper.writeValueAsString(endpointException.getSerializationData()));
        }
        String errorMessage = String.format("Endpoint '%s' method '%s' execution failure", endpointName, methodName);
        VaadinConnectController.getLogger().error(errorMessage, (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)this.createResponseErrorObject(errorMessage));
    }

    private String createResponseErrorObject(String errorMessage) throws JsonProcessingException {
        return this.vaadinEndpointMapper.writeValueAsString(Collections.singletonMap("message", errorMessage));
    }

    private String listMethodParameterTypes(Type[] javaParameters) {
        return Stream.of(javaParameters).map(Type::getTypeName).collect(Collectors.joining(", "));
    }

    private Object[] getVaadinEndpointParameters(Map<String, JsonNode> requestParameters, Type[] javaParameters, String methodName, String endpointName) {
        Object[] endpointParameters = new Object[javaParameters.length];
        String[] parameterNames = new String[requestParameters.size()];
        requestParameters.keySet().toArray(parameterNames);
        HashMap<String, String> errorParams = new HashMap<String, String>();
        LinkedHashSet<ConstraintViolation<Object>> constraintViolations = new LinkedHashSet<ConstraintViolation<Object>>();
        for (int i = 0; i < javaParameters.length; ++i) {
            Type expectedType = javaParameters[i];
            try {
                Object parameter;
                endpointParameters[i] = parameter = this.vaadinEndpointMapper.readerFor(this.vaadinEndpointMapper.getTypeFactory().constructType(expectedType)).readValue(requestParameters.get(parameterNames[i]));
                if (parameter == null) continue;
                constraintViolations.addAll(this.validator.validate(parameter, new Class[0]));
                continue;
            }
            catch (IOException e) {
                String typeName = expectedType.getTypeName();
                VaadinConnectController.getLogger().error("Unable to deserialize an endpoint '{}' method '{}' parameter '{}' with type '{}'", new Object[]{endpointName, methodName, parameterNames[i], typeName, e});
                errorParams.put(parameterNames[i], typeName);
            }
        }
        if (errorParams.isEmpty() && constraintViolations.isEmpty()) {
            return endpointParameters;
        }
        throw this.getInvalidEndpointParametersException(methodName, endpointName, errorParams, constraintViolations);
    }

    private EndpointValidationException getInvalidEndpointParametersException(String methodName, String endpointName, Map<String, String> deserializationErrors, Set<ConstraintViolation<Object>> constraintViolations) {
        ArrayList<EndpointValidationException.ValidationErrorData> validationErrorData = new ArrayList<EndpointValidationException.ValidationErrorData>(deserializationErrors.size() + constraintViolations.size());
        for (Map.Entry<String, String> deserializationError : deserializationErrors.entrySet()) {
            String message = String.format("Unable to deserialize an endpoint method parameter into type '%s'", deserializationError.getValue());
            validationErrorData.add(new EndpointValidationException.ValidationErrorData(message, deserializationError.getKey()));
        }
        validationErrorData.addAll(this.createBeanValidationErrors(constraintViolations));
        String message = String.format("Validation error in endpoint '%s' method '%s'", endpointName, methodName);
        return new EndpointValidationException(message, validationErrorData);
    }

    private List<EndpointValidationException.ValidationErrorData> createBeanValidationErrors(Collection<ConstraintViolation<Object>> beanConstraintViolations) {
        return beanConstraintViolations.stream().map(constraintViolation -> new EndpointValidationException.ValidationErrorData(String.format("Object of type '%s' has invalid property '%s' with value '%s', validation error: '%s'", constraintViolation.getRootBeanClass(), constraintViolation.getPropertyPath().toString(), constraintViolation.getInvalidValue(), constraintViolation.getMessage()), constraintViolation.getPropertyPath().toString())).collect(Collectors.toList());
    }

    private List<EndpointValidationException.ValidationErrorData> createMethodValidationErrors(Collection<ConstraintViolation<Object>> methodConstraintViolations) {
        return methodConstraintViolations.stream().map(constraintViolation -> {
            String parameterPath = constraintViolation.getPropertyPath().toString();
            return new EndpointValidationException.ValidationErrorData(String.format("Method '%s' of the object '%s' received invalid parameter '%s' with value '%s', validation error: '%s'", parameterPath.split("\\.")[0], constraintViolation.getRootBeanClass(), parameterPath, constraintViolation.getInvalidValue(), constraintViolation.getMessage()), parameterPath);
        }).collect(Collectors.toList());
    }

    private Map<String, JsonNode> getRequestParameters(ObjectNode body) {
        LinkedHashMap<String, JsonNode> parametersData = new LinkedHashMap<String, JsonNode>();
        if (body != null) {
            body.fields().forEachRemaining(entry -> {
                JsonNode cfr_ignored_0 = (JsonNode)parametersData.put((String)entry.getKey(), (JsonNode)entry.getValue());
            });
        }
        return parametersData;
    }

    VaadinConnectAccessChecker getAccessChecker(ServletContext servletContext) {
        VaadinServletContext vaadinServletContext = new VaadinServletContext(servletContext);
        VaadinConnectAccessCheckerWrapper wrapper = (VaadinConnectAccessCheckerWrapper)vaadinServletContext.getAttribute(VaadinConnectAccessCheckerWrapper.class, () -> {
            VaadinConnectAccessChecker accessChecker = (VaadinConnectAccessChecker)this.applicationContext.getBean(VaadinConnectAccessChecker.class);
            ApplicationConfiguration cfg = ApplicationConfiguration.get((VaadinContext)vaadinServletContext);
            if (cfg != null) {
                accessChecker.enableCsrf(cfg.isXsrfProtectionEnabled());
            }
            return new VaadinConnectAccessCheckerWrapper(accessChecker);
        });
        return wrapper.accessChecker;
    }

    private static class VaadinConnectAccessCheckerWrapper {
        private final VaadinConnectAccessChecker accessChecker;

        private VaadinConnectAccessCheckerWrapper(VaadinConnectAccessChecker checker) {
            this.accessChecker = checker;
        }
    }

    static class VaadinEndpointData {
        final Map<String, Method> methods = new HashMap<String, Method>();
        private final Object vaadinEndpointObject;

        private VaadinEndpointData(Object vaadinEndpointObject, Method ... endpointMethods) {
            this.vaadinEndpointObject = vaadinEndpointObject;
            Stream.of(endpointMethods).filter(method -> method.getDeclaringClass() != Object.class && !method.isBridge()).forEach(method -> this.methods.put(method.getName().toLowerCase(Locale.ENGLISH), (Method)method));
        }

        private Optional<Method> getMethod(String methodName) {
            return Optional.ofNullable(this.methods.get(methodName));
        }

        private Object getEndpointObject() {
            return this.vaadinEndpointObject;
        }
    }
}

