/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.connect;

import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.server.connect.EndpointNameChecker;
import com.vaadin.flow.server.connect.EndpointRegistry;
import com.vaadin.flow.server.connect.EndpointUtil;
import com.vaadin.flow.server.connect.ExplicitNullableTypeChecker;
import com.vaadin.flow.server.connect.VaadinConnectController;
import com.vaadin.flow.server.connect.VaadinEndpointProperties;
import com.vaadin.flow.server.connect.auth.CsrfChecker;
import com.vaadin.flow.server.connect.auth.VaadinConnectAccessChecker;
import java.lang.reflect.Method;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class VaadinConnectControllerConfiguration {
    private final VaadinEndpointProperties vaadinEndpointProperties;

    public VaadinConnectControllerConfiguration(VaadinEndpointProperties vaadinEndpointProperties) {
        this.vaadinEndpointProperties = vaadinEndpointProperties;
    }

    @Bean
    public WebMvcRegistrations webMvcRegistrationsHandlerMapping() {
        return new WebMvcRegistrations(){

            public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
                return new RequestMappingHandlerMapping(){

                    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
                        if (VaadinConnectController.class.equals(method.getDeclaringClass())) {
                            mapping = VaadinConnectControllerConfiguration.this.prependEndpointPrefixUrl(mapping);
                        }
                        super.registerHandlerMethod(handler, method, mapping);
                    }
                };
            }
        };
    }

    private RequestMappingInfo prependEndpointPrefixUrl(RequestMappingInfo mapping) {
        PatternsRequestCondition connectEndpointPattern = new PatternsRequestCondition(new String[]{this.vaadinEndpointProperties.getVaadinEndpointPrefix()}).combine(mapping.getPatternsCondition());
        return new RequestMappingInfo(mapping.getName(), connectEndpointPattern, mapping.getMethodsCondition(), mapping.getParamsCondition(), mapping.getHeadersCondition(), mapping.getConsumesCondition(), mapping.getProducesCondition(), mapping.getCustomCondition());
    }

    @Bean
    public EndpointNameChecker endpointNameChecker() {
        return new EndpointNameChecker();
    }

    @Bean
    public VaadinConnectAccessChecker accessChecker(AccessAnnotationChecker accessAnnotationChecker, CsrfChecker csrfChecker) {
        return new VaadinConnectAccessChecker(accessAnnotationChecker, csrfChecker);
    }

    @Bean
    public AccessAnnotationChecker accessAnnotationChecker() {
        return new AccessAnnotationChecker();
    }

    @Bean
    public CsrfChecker csrfChecker() {
        return new CsrfChecker();
    }

    @Bean
    public ExplicitNullableTypeChecker typeChecker() {
        return new ExplicitNullableTypeChecker();
    }

    @Bean
    public EndpointUtil endpointUtil() {
        return new EndpointUtil();
    }

    @Bean
    public EndpointRegistry endpointRegistry(EndpointNameChecker endpointNameChecker) {
        return new EndpointRegistry(endpointNameChecker);
    }
}

