/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import com.vaadin.fusion.frontend.AbstractTaskConnectGenerator;
import com.vaadin.fusion.generator.OpenApiSpecGenerator;
import java.io.File;
import java.util.Collections;
import java.util.Objects;

public class TaskGenerateOpenAPIImpl
extends AbstractTaskConnectGenerator
implements TaskGenerateOpenAPI {
    private final File javaSourceFolder;
    private final ClassLoader classLoader;
    private final File output;

    TaskGenerateOpenAPIImpl(File properties, File javaSourceFolder, ClassLoader classLoader, File output) {
        super(properties);
        Objects.requireNonNull(javaSourceFolder, "Source paths should not be null.");
        Objects.requireNonNull(output, "OpenAPI output file should not be null.");
        Objects.requireNonNull(classLoader, "ClassLoader should not be null.");
        this.javaSourceFolder = javaSourceFolder;
        this.classLoader = classLoader;
        this.output = output;
    }

    public void execute() throws ExecutionFailedException {
        OpenApiSpecGenerator openApiSpecGenerator = new OpenApiSpecGenerator(this.readApplicationProperties());
        openApiSpecGenerator.generateOpenApiSpec(Collections.singletonList(this.javaSourceFolder.toPath()), this.classLoader, this.output.toPath());
    }
}

