/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.generator;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenerationOutputDirectory {
    private final Logger logger = LoggerFactory.getLogger((String)GenerationOutputDirectory.class.getName());
    private final File outputDirectory;
    private final GeneratorFileVisitor visitor = new GeneratorFileVisitor(this.logger);

    GenerationOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String toString() {
        return this.outputDirectory.toString();
    }

    void clean() {
        this.clean(Collections.emptySet());
    }

    void clean(Set<File> files) {
        if (!this.outputDirectory.exists()) {
            return;
        }
        this.visitor.setGeneratedFiles(files);
        try {
            Files.walkFileTree(this.outputDirectory.toPath(), this.visitor);
        }
        catch (IOException e) {
            this.logger.info(String.format("Failed to access folder '%s' while cleaning generated sources.", this.outputDirectory.toPath().toAbsolutePath()), (Throwable)e);
        }
    }

    Path toPath() {
        return this.outputDirectory.toPath();
    }

    static class GeneratorFileVisitor
    extends SimpleFileVisitor<Path> {
        private static final List<String> filesToKeep = Arrays.asList("connect-client.default.ts", "vaadin.ts", "vite-devmode.ts", "index.ts", "index.js", "theme.js", "theme.d.ts");
        private final Logger logger;
        private Set<File> generatedFiles;

        GeneratorFileVisitor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException exc) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                if (!stream.iterator().hasNext()) {
                    this.remove(path);
                }
            }
            catch (IOException e) {
                this.logger.info(String.format("Failed to access folder '%s' while cleaning generated sources.", path.toAbsolutePath()), (Throwable)e);
            }
            return FileVisitResult.CONTINUE;
        }

        public void setGeneratedFiles(Set<File> generatedFiles) {
            this.generatedFiles = generatedFiles;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attr) {
            File file = path.toFile();
            if (this.generatedFiles.contains(file)) {
                return FileVisitResult.CONTINUE;
            }
            String fileName = file.getName();
            if (filesToKeep.contains(fileName) || fileName.endsWith(".generated.js")) {
                return FileVisitResult.CONTINUE;
            }
            this.remove(path);
            return FileVisitResult.CONTINUE;
        }

        private void remove(Path path) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                this.logger.info(String.format("Failed to remove '%s' while cleaning the generated folder.", path.toAbsolutePath()), (Throwable)e);
            }
        }
    }
}

