/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion;

import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.fusion.EndpointNameChecker;
import com.vaadin.fusion.EndpointRegistry;
import com.vaadin.fusion.EndpointUtil;
import com.vaadin.fusion.ExplicitNullableTypeChecker;
import com.vaadin.fusion.FusionController;
import com.vaadin.fusion.FusionEndpointProperties;
import com.vaadin.fusion.auth.CsrfChecker;
import com.vaadin.fusion.auth.FusionAccessChecker;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPatternParser;

@Configuration
public class FusionControllerConfiguration {
    private final FusionEndpointProperties fusionEndpointProperties;

    public FusionControllerConfiguration(FusionEndpointProperties fusionEndpointProperties) {
        this.fusionEndpointProperties = fusionEndpointProperties;
    }

    @Bean
    public WebMvcRegistrations webMvcRegistrationsHandlerMapping() {
        return new WebMvcRegistrations(){

            public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
                return new RequestMappingHandlerMapping(){

                    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
                        if (FusionController.class.equals(method.getDeclaringClass())) {
                            mapping = FusionControllerConfiguration.this.prependEndpointPrefixUrl(mapping);
                        }
                        super.registerHandlerMethod(handler, method, mapping);
                    }
                };
            }
        };
    }

    private RequestMappingInfo prependEndpointPrefixUrl(RequestMappingInfo mapping) {
        RequestMappingInfo.Builder prefixMappingBuilder = RequestMappingInfo.paths((String[])new String[]{this.fusionEndpointProperties.getVaadinEndpointPrefix()});
        if (mapping.getPatternsCondition() == null) {
            RequestMappingInfo.BuilderConfiguration options = new RequestMappingInfo.BuilderConfiguration();
            options.setPatternParser(PathPatternParser.defaultInstance);
            prefixMappingBuilder.options(options);
        }
        return prefixMappingBuilder.build().combine(mapping);
    }

    @Bean
    public EndpointNameChecker endpointNameChecker() {
        return new EndpointNameChecker();
    }

    @Bean
    public FusionAccessChecker accessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        return new FusionAccessChecker(accessAnnotationChecker);
    }

    @Bean
    @ConditionalOnMissingBean
    public AccessAnnotationChecker accessAnnotationChecker() {
        return new AccessAnnotationChecker();
    }

    @Bean
    public CsrfChecker csrfChecker(ServletContext servletContext) {
        return new CsrfChecker(servletContext);
    }

    @Bean
    public ExplicitNullableTypeChecker typeChecker() {
        return new ExplicitNullableTypeChecker();
    }

    @Bean
    public EndpointUtil endpointUtil() {
        return new EndpointUtil();
    }

    @Bean
    public EndpointRegistry endpointRegistry(EndpointNameChecker endpointNameChecker) {
        return new EndpointRegistry(endpointNameChecker);
    }
}

