/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.internal.hotswap;

import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.hilla.EndpointCodeGenerator;
import com.vaadin.hilla.internal.hotswap.EndpointHotSwapService;
import com.vaadin.hilla.internal.hotswap.HotSwapListener;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EndpointHotSwapListener
implements HotSwapListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointHotSwapListener.class);
    private final EndpointHotSwapService endpointHotSwapService;

    public EndpointHotSwapListener(EndpointHotSwapService endpointHotSwapService) {
        this.endpointHotSwapService = endpointHotSwapService;
    }

    @PostConstruct
    private void registerForHotSwapChanges() {
        this.endpointHotSwapService.addHotSwapListener(this);
    }

    @Override
    public void endpointChanged(HotSwapListener.EndpointChangedEvent event) {
        try {
            EndpointCodeGenerator.getInstance().update();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.reload(event.browserLiveReload());
    }

    private void reload(BrowserLiveReload browserLiveReload) {
        Optional.ofNullable(browserLiveReload).ifPresent(liveReload -> {
            LOGGER.debug("Reloading the browser after endpoint(s) changes...");
            liveReload.reload();
        });
    }
}

