/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.route.records;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.hilla.route.records.ClientViewMenuConfig;
import com.vaadin.hilla.route.records.RouteParamType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record AvailableViewInfo(String title, String[] rolesAllowed, Boolean requiresLogin, String route, Boolean lazy, Boolean register, ClientViewMenuConfig menu, @JsonProperty(value="params") Map<String, RouteParamType> routeParameters) {
    public AvailableViewInfo(String title, String[] rolesAllowed, Boolean requiresLogin, String route, Boolean lazy, Boolean register, ClientViewMenuConfig menu, Stream<RouteParameterData> routeParameters) {
        this(title, rolesAllowed, requiresLogin, route, lazy, register, menu, routeParameters.collect(Collectors.toMap(RouteParameterData::getTemplate, params -> {
            if (params.getTemplate().contains("*")) {
                return RouteParamType.WILDCARD;
            }
            if (params.getTemplate().contains("?")) {
                return RouteParamType.OPTIONAL;
            }
            return RouteParamType.REQUIRED;
        })));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableViewInfo that = (AvailableViewInfo)o;
        return Objects.equals(this.title, that.title) && Arrays.equals(this.rolesAllowed, that.rolesAllowed) && Objects.equals(this.requiresLogin, that.requiresLogin) && Objects.equals(this.route, that.route) && Objects.equals(this.lazy, that.lazy) && Objects.equals(this.register, that.register) && Objects.equals(this.menu, that.menu) && Objects.equals(this.routeParameters, that.routeParameters);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.title, this.route, this.lazy, this.register, this.menu, this.routeParameters);
        result = 31 * result + Arrays.hashCode(this.rolesAllowed);
        return result;
    }

    @Override
    public String toString() {
        return "AvailableViewInfo{title='" + this.title + "', rolesAllowed=" + Arrays.toString(this.rolesAllowed) + ", requiresLogin=" + this.requiresLogin + ", route='" + this.route + "', lazy=" + this.lazy + ", register=" + this.register + ", menu=" + this.menu + ", routeParameters=" + this.routeParameters + "}";
    }
}

