/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.startup;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.hilla.HillaStats;
import com.vaadin.hilla.route.ClientRouteRegistry;
import com.vaadin.hilla.route.RouteUnifyingConfigurationProperties;
import com.vaadin.hilla.route.RouteUnifyingIndexHtmlRequestListener;
import com.vaadin.hilla.route.RouteUtil;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
public class RouteUnifyingServiceInitListener
implements VaadinServiceInitListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteUnifyingServiceInitListener.class);
    private final ClientRouteRegistry clientRouteRegistry;
    private final RouteUtil routeUtil;
    private final RouteUnifyingConfigurationProperties routeUnifyingConfigurationProperties;
    private final NavigationAccessControl accessControl;
    private final ViewAccessChecker viewAccessChecker;

    @Autowired
    public RouteUnifyingServiceInitListener(ClientRouteRegistry clientRouteRegistry, RouteUtil routeUtil, RouteUnifyingConfigurationProperties routeUnifyingConfigurationProperties, @Nullable NavigationAccessControl accessControl, @Nullable ViewAccessChecker viewAccessChecker) {
        this.clientRouteRegistry = clientRouteRegistry;
        this.routeUtil = routeUtil;
        this.routeUnifyingConfigurationProperties = routeUnifyingConfigurationProperties;
        this.accessControl = accessControl;
        this.viewAccessChecker = viewAccessChecker;
    }

    public void serviceInit(ServiceInitEvent event) {
        DeploymentConfiguration deploymentConfiguration = event.getSource().getDeploymentConfiguration();
        LOGGER.debug("deploymentConfiguration.isReactEnabled() = {}", (Object)deploymentConfiguration.isReactEnabled());
        boolean hasHillaFsRoute = false;
        if (deploymentConfiguration.isReactEnabled()) {
            RouteUnifyingIndexHtmlRequestListener routeUnifyingIndexHtmlRequestListener = new RouteUnifyingIndexHtmlRequestListener(this.clientRouteRegistry, deploymentConfiguration, this.routeUtil, this.accessControl, this.viewAccessChecker, this.routeUnifyingConfigurationProperties.isExposeServerRoutesToClient());
            String deploymentMode = deploymentConfiguration.isProductionMode() ? "PRODUCTION" : "DEVELOPMENT";
            event.addIndexHtmlRequestListener((IndexHtmlRequestListener)routeUnifyingIndexHtmlRequestListener);
            LOGGER.debug("{} mode: Registered RouteUnifyingIndexHtmlRequestListener.", (Object)deploymentMode);
            this.clientRouteRegistry.registerClientRoutes(deploymentConfiguration, LocalDateTime.now());
            hasHillaFsRoute = !this.clientRouteRegistry.getAllRoutes().isEmpty();
        }
        HillaStats.reportGenericHasFeatures(event.getSource(), hasHillaFsRoute);
    }
}

