/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.route;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.AnnotationReader;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteParameterData;
import com.vaadin.flow.server.RouteRegistry;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.auth.MenuAccessControl;
import com.vaadin.flow.server.auth.NavigationAccessControl;
import com.vaadin.flow.server.auth.ViewAccessChecker;
import com.vaadin.flow.server.communication.IndexHtmlRequestListener;
import com.vaadin.flow.server.communication.IndexHtmlResponse;
import com.vaadin.hilla.route.ClientRouteRegistry;
import com.vaadin.hilla.route.RouteUtil;
import com.vaadin.hilla.route.records.AvailableViewInfo;
import com.vaadin.hilla.route.records.ClientViewConfig;
import com.vaadin.hilla.route.records.ClientViewMenuConfig;
import com.vaadin.hilla.route.records.RouteParamType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class RouteUnifyingIndexHtmlRequestListener
implements IndexHtmlRequestListener {
    protected static final String SCRIPT_STRING = "window.Vaadin = window.Vaadin ?? {};\nwindow.Vaadin.views = %s;";
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteUnifyingIndexHtmlRequestListener.class);
    private final ClientRouteRegistry clientRouteRegistry;
    private final ObjectMapper mapper = new ObjectMapper();
    private final DeploymentConfiguration deploymentConfiguration;
    private final RouteUtil routeUtil;
    private final NavigationAccessControl accessControl;
    private final ViewAccessChecker viewAccessChecker;
    private final boolean exposeServerRoutesToClient;

    public RouteUnifyingIndexHtmlRequestListener(ClientRouteRegistry clientRouteRegistry, DeploymentConfiguration deploymentConfiguration, RouteUtil routeUtil, @Nullable NavigationAccessControl accessControl, @Nullable ViewAccessChecker viewAccessChecker, boolean exposeServerRoutesToClient) {
        this.clientRouteRegistry = clientRouteRegistry;
        this.deploymentConfiguration = deploymentConfiguration;
        this.routeUtil = routeUtil;
        this.accessControl = accessControl;
        this.viewAccessChecker = viewAccessChecker;
        this.exposeServerRoutesToClient = exposeServerRoutesToClient;
    }

    public void modifyIndexHtmlResponse(IndexHtmlResponse response) {
        boolean isUserAuthenticated = response.getVaadinRequest().getUserPrincipal() != null;
        HashMap<String, AvailableViewInfo> availableViews = new HashMap<String, AvailableViewInfo>(this.collectClientViews(arg_0 -> ((VaadinRequest)response.getVaadinRequest()).isUserInRole(arg_0), isUserAuthenticated));
        if (this.exposeServerRoutesToClient) {
            LOGGER.debug("Exposing server-side views to the client based on user configuration");
            availableViews.putAll(this.collectServerViews(response.getVaadinRequest()));
        }
        if (availableViews.isEmpty()) {
            LOGGER.debug("No server-side nor client-side views found, skipping response modification.");
            return;
        }
        try {
            String fileRoutesJson = this.mapper.writeValueAsString(availableViews);
            String script = SCRIPT_STRING.formatted(fileRoutesJson);
            response.getDocument().head().appendElement("script").appendChild((Node)new DataNode(script));
        }
        catch (IOException e) {
            LOGGER.error("Failure while to write client and server routes to index html response", (Throwable)e);
        }
    }

    protected Map<String, AvailableViewInfo> collectClientViews(Predicate<? super String> isUserInRole, boolean isUserAuthenticated) {
        if (!this.deploymentConfiguration.isProductionMode()) {
            this.clientRouteRegistry.loadLatestDevModeFileRoutesJsonIfNeeded(this.deploymentConfiguration);
        }
        return this.clientRouteRegistry.getAllRoutes().entrySet().stream().filter(viewMapping -> !this.hasRequiredParameter((ClientViewConfig)viewMapping.getValue())).filter(viewMapping -> this.routeUtil.isRouteAllowed(isUserInRole, isUserAuthenticated, (ClientViewConfig)viewMapping.getValue())).collect(Collectors.toMap(Map.Entry::getKey, viewMapping -> this.toAvailableViewInfo((ClientViewConfig)viewMapping.getValue())));
    }

    private boolean hasRequiredParameter(ClientViewConfig config) {
        Map<String, RouteParamType> routeParameters = config.getRouteParameters();
        if (routeParameters != null && !routeParameters.isEmpty() && routeParameters.values().stream().anyMatch(paramType -> paramType == RouteParamType.REQUIRED)) {
            return true;
        }
        ClientViewConfig parentConfig = config.getParent();
        if (parentConfig != null) {
            return this.hasRequiredParameter(parentConfig);
        }
        return false;
    }

    private AvailableViewInfo toAvailableViewInfo(ClientViewConfig config) {
        return new AvailableViewInfo(config.getTitle(), config.getRolesAllowed(), (Boolean)config.isLoginRequired(), config.getRoute(), (Boolean)config.isLazy(), (Boolean)config.isAutoRegistered(), config.menu(), config.getRouteParameters());
    }

    protected Map<String, AvailableViewInfo> collectServerViews(VaadinRequest vaadinRequest) {
        VaadinService vaadinService = VaadinService.getCurrent();
        if (vaadinService == null) {
            LOGGER.debug("No VaadinService found, skipping server view collection");
            return Collections.emptyMap();
        }
        RouteRegistry serverRouteRegistry = vaadinService.getRouter().getRegistry();
        List<BeforeEnterListener> accessControls = Stream.of(this.accessControl, this.viewAccessChecker).filter(Objects::nonNull).toList();
        List serverRoutes = Collections.emptyList();
        if (vaadinService.getInstantiator().getMenuAccessControl().getPopulateClientSideMenu() == MenuAccessControl.PopulateClientMenu.ALWAYS || this.clientRouteRegistry.hasMainLayout()) {
            serverRoutes = serverRouteRegistry.getRegisteredAccessibleMenuRoutes(vaadinRequest, accessControls);
        }
        return serverRoutes.stream().filter(serverView -> serverView.getTemplate() != null).map(serverView -> {
            Class viewClass = serverView.getNavigationTarget();
            String url = RouteUnifyingIndexHtmlRequestListener.getRouteUrl(serverView);
            PageTitle pageTitle = AnnotationReader.getAnnotationFor((Class)viewClass, PageTitle.class).orElse(null);
            String title = pageTitle != null ? pageTitle.value() : serverView.getNavigationTarget().getSimpleName();
            ClientViewMenuConfig menuConfig = Optional.ofNullable(serverView.getMenuData()).map(menu -> new ClientViewMenuConfig(menu.getTitle() == null || menu.getTitle().isBlank() ? title : menu.getTitle(), menu.getOrder(), menu.getIcon(), menu.isExclude())).orElse(null);
            return new AvailableViewInfo(title, null, (Boolean)false, url, (Boolean)false, (Boolean)false, menuConfig, serverView.getRouteParameters().values().stream());
        }).filter(view -> view.routeParameters().values().stream().noneMatch(param -> param == RouteParamType.REQUIRED)).collect(Collectors.toMap(AvailableViewInfo::route, Function.identity()));
    }

    private Map<String, RouteParamType> getRouteParameters(RouteData serverView) {
        HashMap<String, RouteParamType> routeParameters = new HashMap<String, RouteParamType>();
        serverView.getRouteParameters().forEach((route, params) -> {
            if (params.getTemplate().contains("*")) {
                routeParameters.put(params.getTemplate(), RouteParamType.WILDCARD);
            } else if (params.getTemplate().contains("?")) {
                routeParameters.put(params.getTemplate(), RouteParamType.OPTIONAL);
            } else {
                routeParameters.put(params.getTemplate(), RouteParamType.REQUIRED);
            }
        });
        return routeParameters;
    }

    private static String getRouteUrl(RouteData route) {
        if (route.getRouteParameters() != null && !route.getRouteParameters().isEmpty()) {
            Object editUrl = "/" + route.getTemplate();
            List<RouteParameterData> params = route.getRouteParameters().values().stream().filter(param -> param.getTemplate().contains("?") || param.getTemplate().contains("*")).toList();
            for (RouteParameterData param2 : params) {
                editUrl = ((String)editUrl).replace("/" + param2.getTemplate(), "");
            }
            if (((String)editUrl).isEmpty()) {
                editUrl = "/";
            }
            return editUrl;
        }
        return "/" + route.getTemplate();
    }
}

