/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import com.vaadin.hilla.Endpoint;
import com.vaadin.hilla.EndpointNameChecker;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class EndpointRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointRegistry.class);
    private final EndpointNameChecker endpointNameChecker;
    private final Map<String, VaadinEndpointData> vaadinEndpoints = new HashMap<String, VaadinEndpointData>();

    public EndpointRegistry(EndpointNameChecker endpointNameChecker) {
        this.endpointNameChecker = endpointNameChecker;
    }

    private static String getEndpointNameForClass(Class<?> beanType) {
        return Optional.ofNullable(beanType.getAnnotation(Endpoint.class)).map(Endpoint::value).filter(value -> !value.isEmpty()).orElse(beanType.getSimpleName());
    }

    void registerEndpoint(Object endpointBean) {
        Class beanType = ClassUtils.getUserClass(endpointBean.getClass());
        String endpointName = EndpointRegistry.getEndpointNameForClass(beanType);
        if (endpointName.isEmpty()) {
            throw new IllegalStateException(String.format("A bean with type '%s' is annotated with '%s' annotation but is an anonymous class hence has no name. ", beanType, Endpoint.class) + String.format("Either modify the bean declaration so that it is not an anonymous class or specify an endpoint name in the '%s' annotation", Endpoint.class));
        }
        String validationError = this.endpointNameChecker.check(endpointName);
        if (validationError != null) {
            throw new IllegalStateException(String.format("Endpoint name '%s' is invalid, reason: '%s'", endpointName, validationError));
        }
        AccessibleObject[] endpointPublicMethods = beanType.getMethods();
        AccessibleObject.setAccessible(endpointPublicMethods, true);
        this.vaadinEndpoints.put(endpointName.toLowerCase(Locale.ENGLISH), new VaadinEndpointData(endpointBean, (Method[])endpointPublicMethods));
        LOGGER.debug("Registered endpoint '{}' with class '{}'", (Object)endpointName, (Object)beanType);
    }

    public Map<String, VaadinEndpointData> getEndpoints() {
        return this.vaadinEndpoints;
    }

    VaadinEndpointData get(String endpointName) {
        return this.vaadinEndpoints.get(endpointName.toLowerCase(Locale.ENGLISH));
    }

    boolean isEmpty() {
        return this.vaadinEndpoints.isEmpty();
    }

    public static class VaadinEndpointData {
        final Map<String, Method> methods = new HashMap<String, Method>();
        private final Object vaadinEndpointObject;

        private VaadinEndpointData(Object vaadinEndpointObject, Method ... endpointMethods) {
            this.vaadinEndpointObject = vaadinEndpointObject;
            Stream.of(endpointMethods).filter(method -> method.getDeclaringClass() != Object.class && !method.isBridge()).forEach(method -> this.methods.put(method.getName().toLowerCase(Locale.ENGLISH), (Method)method));
        }

        public Map<String, Method> getMethods() {
            return this.methods;
        }

        public Optional<Method> getMethod(String methodName) {
            return Optional.ofNullable(this.methods.get(methodName.toLowerCase(Locale.ENGLISH)));
        }

        public Object getEndpointObject() {
            return this.vaadinEndpointObject;
        }
    }
}

