/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.core.registry;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.AuthenticationUtil;
import com.vaadin.hilla.EndpointInvocationException;
import com.vaadin.hilla.EndpointInvoker;
import com.vaadin.hilla.EndpointRegistry;
import com.vaadin.hilla.signals.Signal;
import com.vaadin.hilla.signals.core.registry.SignalsRegistry;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class SecureSignalsRegistry {
    private final Map<String, EndpointMethod> endpointMethods = new HashMap<String, EndpointMethod>();
    private final SignalsRegistry delegate;
    private final EndpointInvoker invoker;

    public SecureSignalsRegistry(EndpointInvoker invoker) {
        this.invoker = invoker;
        this.delegate = new SignalsRegistry();
    }

    public synchronized void register(String clientSignalId, String endpointName, String methodName, ObjectNode body) throws EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointNotFoundException, EndpointInvocationException.EndpointBadRequestException, EndpointInvocationException.EndpointInternalException {
        Authentication principal = AuthenticationUtil.getSecurityHolderAuthentication();
        Function<String, Boolean> isInRole = AuthenticationUtil.getSecurityHolderRoleChecker();
        this.checkAccess(endpointName, methodName, (Principal)principal, isInRole);
        Signal signal = (Signal)this.invoker.invoke(endpointName, methodName, body, (Principal)principal, isInRole);
        this.endpointMethods.put(clientSignalId, new EndpointMethod(endpointName, methodName));
        this.delegate.register(clientSignalId, signal);
    }

    public synchronized void unsubscribe(String clientSignalId) {
        EndpointMethod endpointMethodInfo = this.endpointMethods.get(clientSignalId);
        if (endpointMethodInfo == null) {
            return;
        }
        this.delegate.removeClientSignalToSignalMapping(clientSignalId);
        this.endpointMethods.remove(clientSignalId);
    }

    public synchronized Signal<?> get(String clientSignalId) throws EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointNotFoundException {
        EndpointMethod endpointMethodInfo = this.endpointMethods.get(clientSignalId);
        if (endpointMethodInfo == null) {
            return null;
        }
        this.checkAccess(endpointMethodInfo.endpoint, endpointMethodInfo.method);
        return this.delegate.get(clientSignalId);
    }

    private void checkAccess(String endpointName, String methodName) throws EndpointInvocationException.EndpointNotFoundException, EndpointInvocationException.EndpointAccessDeniedException {
        Authentication principal = AuthenticationUtil.getSecurityHolderAuthentication();
        Function<String, Boolean> isInRole = AuthenticationUtil.getSecurityHolderRoleChecker();
        this.checkAccess(endpointName, methodName, (Principal)principal, isInRole);
    }

    private void checkAccess(String endpointName, String methodName, Principal principal, Function<String, Boolean> isInRole) throws EndpointInvocationException.EndpointNotFoundException, EndpointInvocationException.EndpointAccessDeniedException {
        Method method;
        EndpointRegistry.VaadinEndpointData endpointData = this.invoker.getVaadinEndpointData(endpointName);
        String checkError = this.invoker.checkAccess(endpointData, method = this.getMethod(endpointData, methodName), principal, isInRole);
        if (checkError != null) {
            throw new EndpointInvocationException.EndpointAccessDeniedException(String.format("Endpoint '%s' method '%s' request cannot be accessed, reason: '%s'", endpointName, methodName, checkError));
        }
    }

    private Method getMethod(@NotNull EndpointRegistry.VaadinEndpointData endpointData, String methodName) throws EndpointInvocationException.EndpointNotFoundException {
        return endpointData.getMethod(methodName).orElseThrow(EndpointInvocationException.EndpointNotFoundException::new);
    }

    record EndpointMethod(String endpoint, String method) {
    }
}

