/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vaadin.hilla.ConditionalOnFeatureFlag;
import com.vaadin.hilla.EndpointInvoker;
import com.vaadin.hilla.signals.Signal;
import com.vaadin.hilla.signals.core.registry.SecureSignalsRegistry;
import com.vaadin.hilla.signals.handler.SignalsHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SignalsConfiguration {
    private SecureSignalsRegistry signalsRegistry;
    private SignalsHandler signalsHandler;
    private final EndpointInvoker endpointInvoker;

    public SignalsConfiguration(EndpointInvoker endpointInvoker, ObjectMapper hillaEndpointObjectMapper) {
        this.endpointInvoker = endpointInvoker;
        Signal.setMapper(hillaEndpointObjectMapper);
    }

    @ConditionalOnFeatureFlag(value="fullstackSignals")
    @Bean
    public SecureSignalsRegistry signalsRegistry() {
        if (this.signalsRegistry == null) {
            this.signalsRegistry = new SecureSignalsRegistry(this.endpointInvoker);
        }
        return this.signalsRegistry;
    }

    @ConditionalOnFeatureFlag(value="fullstackSignals")
    @Bean
    public SignalsHandler signalsHandler() {
        if (this.signalsHandler == null) {
            this.signalsHandler = new SignalsHandler(this.signalsRegistry());
        }
        return this.signalsHandler;
    }
}

