/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.hilla.BrowserCallable;
import com.vaadin.hilla.EndpointInvocationException;
import com.vaadin.hilla.signals.Signal;
import com.vaadin.hilla.signals.core.event.ListStateEvent;
import com.vaadin.hilla.signals.core.registry.SecureSignalsRegistry;
import jakarta.annotation.Nullable;
import reactor.core.publisher.Flux;

@AnonymousAllowed
@BrowserCallable
public class SignalsHandler {
    private final SecureSignalsRegistry registry;

    public SignalsHandler(SecureSignalsRegistry registry) {
        this.registry = registry;
    }

    public Flux<ObjectNode> subscribe(String providerEndpoint, String providerMethod, String clientSignalId, ObjectNode body, @Nullable String parentClientSignalId) {
        try {
            if (parentClientSignalId != null) {
                return this.subscribe(parentClientSignalId, clientSignalId);
            }
            Signal<?> signal = this.registry.get(clientSignalId);
            if (signal != null) {
                return signal.subscribe().doFinally(event -> this.registry.unsubscribe(clientSignalId));
            }
            this.registry.register(clientSignalId, providerEndpoint, providerMethod, body);
            return this.registry.get(clientSignalId).subscribe().doFinally(event -> this.registry.unsubscribe(clientSignalId));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    private Flux<ObjectNode> subscribe(String parentClientSignalId, String clientSignalId) throws EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointNotFoundException {
        Signal<?> parentSignal = this.registry.get(parentClientSignalId);
        if (parentSignal == null) {
            throw new IllegalStateException(String.format("Parent Signal not found for parent client signal id: %s", parentClientSignalId));
        }
        return parentSignal.subscribe(clientSignalId).doFinally(event -> this.registry.unsubscribe(clientSignalId));
    }

    public void update(String clientSignalId, ObjectNode event) throws EndpointInvocationException.EndpointAccessDeniedException, EndpointInvocationException.EndpointNotFoundException {
        String parentSignalId = ListStateEvent.extractParentSignalId((JsonNode)event);
        if (parentSignalId != null) {
            if (this.registry.get(parentSignalId) == null) {
                throw new IllegalStateException(String.format("Parent Signal not found for signal id: %s", parentSignalId));
            }
            this.registry.get(parentSignalId).submit(event);
        } else {
            if (this.registry.get(clientSignalId) == null) {
                throw new IllegalStateException(String.format("Signal not found for client signal: %s", clientSignalId));
            }
            this.registry.get(clientSignalId).submit(event);
        }
    }
}

