/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.operation;

public class ValidationResult {
    private final Status status;
    private final String errorMessage;

    private ValidationResult(Status status, String errorMessage) {
        this.status = status;
        this.errorMessage = errorMessage;
    }

    private ValidationResult(Status status) {
        this.status = status;
        this.errorMessage = null;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isOk() {
        return this.status == Status.ALLOWED;
    }

    public boolean isRejected() {
        return this.status == Status.REJECTED;
    }

    public static ValidationResult reject(String errorMessage) {
        return new ValidationResult(Status.REJECTED, errorMessage);
    }

    public static ValidationResult allow() {
        return new ValidationResult(Status.ALLOWED);
    }

    public static enum Status {
        ALLOWED,
        REJECTED;

    }
}

