/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.vaadin.hilla.engine.ConfigurationException;
import com.vaadin.hilla.engine.GeneratorConfiguration;
import com.vaadin.hilla.engine.ParserConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EngineConfiguration {
    public static final String DEFAULT_CONFIG_FILE_NAME = "hilla-engine-configuration.json";
    public static final String OPEN_API_PATH = "hilla-openapi.json";
    static final ObjectMapper MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private Path baseDir;
    private Path buildDir;
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<Path> classPath;
    private Path classesDir;
    private GeneratorConfiguration generator;
    private Path outputDir;
    private ParserConfiguration parser;

    private EngineConfiguration() {
    }

    public static EngineConfiguration loadDirectory(Path configDir) throws IOException {
        return EngineConfiguration.load(configDir.resolve(DEFAULT_CONFIG_FILE_NAME).toFile());
    }

    public static EngineConfiguration load(File configFile) throws IOException {
        if (!configFile.isFile()) {
            return null;
        }
        try {
            return (EngineConfiguration)MAPPER.readValue(configFile, EngineConfiguration.class);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineConfiguration that = (EngineConfiguration)o;
        return Objects.equals(this.baseDir, that.baseDir) && Objects.equals(this.classPath, that.classPath) && Objects.equals(this.generator, that.generator) && Objects.equals(this.parser, that.parser) && Objects.equals(this.buildDir, that.buildDir) && Objects.equals(this.classesDir, that.classesDir) && Objects.equals(this.outputDir, that.outputDir);
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getBuildDir() {
        return this.buildDir;
    }

    public Set<Path> getClassPath() {
        return this.classPath;
    }

    public Path getClassesDir() {
        return this.classesDir;
    }

    public GeneratorConfiguration getGenerator() {
        return this.generator;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public ParserConfiguration getParser() {
        return this.parser;
    }

    public int hashCode() {
        return Objects.hash(this.baseDir, this.classPath, this.generator, this.parser, this.buildDir, this.classesDir, this.outputDir);
    }

    public void store(File file) throws IOException {
        MAPPER.writeValue(file, (Object)this);
    }

    @JsonIgnore
    public Path getOpenAPIFile(boolean isProductionMode) {
        return isProductionMode ? this.classesDir.resolve(OPEN_API_PATH) : this.buildDir.resolve(OPEN_API_PATH);
    }

    public static final class Builder {
        private final EngineConfiguration configuration = new EngineConfiguration();

        public Builder(Path baseDir) {
            this.configuration.baseDir = baseDir;
            Path legacyFrontendGeneratedDir = baseDir.resolve("frontend/generated");
            this.configuration.outputDir = Files.exists(legacyFrontendGeneratedDir, new LinkOption[0]) ? legacyFrontendGeneratedDir : baseDir.resolve("./src/main/frontend/generated/");
        }

        public Builder(EngineConfiguration configuration) {
            this.configuration.baseDir = configuration.baseDir;
            this.configuration.classPath = configuration.classPath;
            this.configuration.generator = configuration.generator;
            this.configuration.parser = configuration.parser;
            this.configuration.buildDir = configuration.buildDir;
            this.configuration.classesDir = configuration.classesDir;
            this.configuration.outputDir = configuration.outputDir;
        }

        public Builder baseDir(Path value) {
            this.configuration.baseDir = value;
            return this;
        }

        public Builder buildDir(String value) {
            return this.buildDir(Path.of(value, new String[0]));
        }

        public Builder buildDir(Path value) {
            this.configuration.buildDir = this.resolve(value);
            return this;
        }

        public Builder classPath(Collection<String> value) {
            this.configuration.classPath = value.stream().map(x$0 -> Path.of(x$0, new String[0])).map(this::resolve).collect(Collectors.toCollection(LinkedHashSet::new));
            return this;
        }

        public Builder classesDir(Path value) {
            this.configuration.classesDir = this.resolve(value);
            return this;
        }

        public Builder classesDir(String value) {
            return this.classesDir(Path.of(value, new String[0]));
        }

        public EngineConfiguration create() {
            return this.configuration;
        }

        public Builder generator(GeneratorConfiguration value) {
            this.configuration.generator = value;
            return this;
        }

        public Builder outputDir(String value) {
            return this.outputDir(Path.of(value, new String[0]));
        }

        public Builder outputDir(Path value) {
            this.configuration.outputDir = this.resolve(value);
            return this;
        }

        public Builder parser(ParserConfiguration value) {
            this.configuration.parser = value;
            return this;
        }

        private Path resolve(Path path) {
            return path.isAbsolute() ? path.normalize() : this.configuration.baseDir.resolve(path).normalize();
        }
    }
}

