/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.backbone;

import com.vaadin.hilla.parser.models.ClassRefSignatureModel;
import com.vaadin.hilla.parser.models.SignatureModel;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.ArrayList;
import java.util.List;

final class SchemaProcessor {
    private final SignatureModel type;

    public SchemaProcessor(SignatureModel type) {
        this.type = type;
    }

    private static <T extends Schema<?>> T nullify(T schema, boolean condition) {
        return (T)schema.nullable(condition ? Boolean.valueOf(true) : null);
    }

    public Schema<?> process() {
        Schema<?> result = this.type.isCharacter() || this.type.isString() ? this.stringSchema() : (this.type.isBoolean() ? this.booleanSchema() : (this.type.hasIntegerType() || this.type.isBigInteger() ? this.integerSchema() : (this.type.hasFloatType() || this.type.isBigDecimal() ? this.numberSchema() : (this.type.isArray() ? this.arraySchema() : (this.type.isIterable() ? this.iterableSchema() : (this.type.isMap() ? this.mapSchema() : (this.type.isDate() ? this.dateSchema() : (this.type.isDateTime() ? this.dateTimeSchema() : (this.type.isClassRef() ? this.refSchema() : this.anySchema())))))))));
        return result;
    }

    private Schema<?> anySchema() {
        return new ObjectSchema();
    }

    private Schema<?> arraySchema() {
        return SchemaProcessor.nullify(new ArraySchema(), true);
    }

    private Schema<?> booleanSchema() {
        return SchemaProcessor.nullify(new BooleanSchema(), !this.type.isPrimitive());
    }

    private Schema<?> dateSchema() {
        return SchemaProcessor.nullify(new DateSchema(), true);
    }

    private Schema<?> dateTimeSchema() {
        return SchemaProcessor.nullify(new DateTimeSchema(), true);
    }

    private Schema<?> integerSchema() {
        return SchemaProcessor.nullify(new IntegerSchema(), !this.type.isPrimitive()).format(this.type.isLong() || this.type.isBigInteger() ? "int64" : "int32");
    }

    private Schema<?> iterableSchema() {
        ArraySchema schema = SchemaProcessor.nullify(new ArraySchema(), true);
        ClassRefSignatureModel _type = (ClassRefSignatureModel)this.type;
        if (this.type.isNonJDKClass()) {
            schema.addExtension("x-class-name", (Object)_type.getName());
        }
        return schema;
    }

    private Schema<?> mapSchema() {
        ClassRefSignatureModel _type = (ClassRefSignatureModel)this.type;
        Schema schema = SchemaProcessor.nullify(new MapSchema(), true).additionalProperties(this.anySchema());
        if (this.type.isNonJDKClass()) {
            schema.addExtension("x-class-name", (Object)_type.getName());
        }
        return schema;
    }

    private Schema<?> numberSchema() {
        return SchemaProcessor.nullify(new NumberSchema(), !this.type.isPrimitive()).format(this.type.isFloat() ? "float" : "double");
    }

    private Schema<?> refSchema() {
        if (this.type.isJDKClass()) {
            return this.anySchema();
        }
        ClassRefSignatureModel _type = (ClassRefSignatureModel)this.type;
        String fullyQualifiedName = _type.getClassInfo().getName();
        return SchemaProcessor.nullify(new ComposedSchema(), true).anyOf(new ArrayList<Schema>(List.of(new Schema().$ref("#/components/schemas/" + fullyQualifiedName))));
    }

    private Schema<?> stringSchema() {
        return SchemaProcessor.nullify(new StringSchema(), !this.type.isPrimitive());
    }
}

