/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.parser.plugins.nonnull;

import com.vaadin.hilla.parser.core.AbstractPlugin;
import com.vaadin.hilla.parser.core.Node;
import com.vaadin.hilla.parser.core.NodeDependencies;
import com.vaadin.hilla.parser.core.NodePath;
import com.vaadin.hilla.parser.core.Plugin;
import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.models.AnnotatedAbstractModel;
import com.vaadin.hilla.parser.models.AnnotatedModel;
import com.vaadin.hilla.parser.models.AnnotationInfoModel;
import com.vaadin.hilla.parser.models.ClassInfoModel;
import com.vaadin.hilla.parser.models.PackageInfoModel;
import com.vaadin.hilla.parser.models.SpecializedModel;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePlugin;
import com.vaadin.hilla.parser.plugins.backbone.nodes.AnnotatedNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.MethodNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.MethodParameterNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.PropertyNode;
import com.vaadin.hilla.parser.plugins.backbone.nodes.TypedNode;
import com.vaadin.hilla.parser.plugins.nonnull.AnnotationMatcher;
import com.vaadin.hilla.parser.plugins.nonnull.NonnullPluginConfig;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class NonnullPlugin
extends AbstractPlugin<NonnullPluginConfig> {
    private Map<String, AnnotationMatcher> annotationsMap = NonnullPlugin.mapByName(NonnullPluginConfig.Processor.defaults);

    private static Map<String, AnnotationMatcher> mapByName(Collection<AnnotationMatcher> annotations) {
        return annotations.stream().collect(Collectors.toMap(AnnotationMatcher::getName, Function.identity()));
    }

    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
        Node node = nodePath.getNode();
        if (node.getTarget() instanceof Schema) {
            Schema schema = (Schema)node.getTarget();
            Object nodeSource = node.getSource();
            if (nodeSource instanceof SpecializedModel && ((SpecializedModel)nodeSource).isOptional()) {
                schema.setNullable(Boolean.valueOf(true));
            } else {
                Stream<AnnotationInfoModel> annotations = this.getPackageAnnotationsStream(nodePath);
                if (node instanceof AnnotatedNode) {
                    annotations = Stream.concat(annotations, ((AnnotatedNode)node).getAnnotations().stream());
                }
                annotations = this.considerAscendantAnnotations(annotations, nodePath);
                annotations.map(annotation -> this.annotationsMap.get(annotation.getName())).filter(Objects::nonNull).max(Comparator.comparingInt(AnnotationMatcher::getScore)).map(AnnotationMatcher::doesMakeNullable).ifPresent(nullable -> schema.setNullable(nullable != false ? Boolean.valueOf(true) : null));
            }
        }
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        return nodeDependencies;
    }

    public void setConfiguration(@Nonnull PluginConfiguration configuration) {
        super.setConfiguration(configuration);
        this.annotationsMap = NonnullPlugin.mapByName(new NonnullPluginConfig.Processor((NonnullPluginConfig)this.getConfiguration()).process());
    }

    private Optional<ClassInfoModel> findClosestClass(NodePath<?> nodePath) {
        return nodePath.stream().map(NodePath::getNode).filter(node -> node.getSource() instanceof ClassInfoModel).map(node -> (ClassInfoModel)node.getSource()).findFirst();
    }

    private Optional<PackageInfoModel> findClosestPackage(NodePath<?> nodePath) {
        return nodePath.stream().map(NodePath::getNode).filter(node -> node.getSource() instanceof ClassInfoModel).map(node -> (ClassInfoModel)node.getSource()).findFirst().map(ClassInfoModel::getPackage);
    }

    private Stream<AnnotationInfoModel> getPackageAnnotationsStream(NodePath<?> nodePath) {
        return this.findClosestPackage(nodePath).stream().map(AnnotatedAbstractModel::getAnnotations).flatMap(Collection::stream);
    }

    private Stream<AnnotationInfoModel> considerAscendantAnnotations(Stream<AnnotationInfoModel> annotations, NodePath<?> nodePath) {
        Node current = nodePath.getNode();
        Node parent = nodePath.getParentPath().getNode();
        if (current instanceof TypedNode && (parent instanceof MethodNode || parent instanceof MethodParameterNode || parent instanceof PropertyNode)) {
            annotations = Stream.concat(annotations, ((AnnotatedModel)parent.getSource()).getAnnotations().stream());
        }
        return annotations;
    }
}

