/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.ProKeyValidator;
import com.vaadin.pro.licensechecker.Product;
import java.time.Instant;
import java.time.Period;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class History {
    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    public static boolean isRecentlyValidated(Product product) {
        History.getLogger().fine("Checking if license for " + product + " has recently been checked");
        Instant lastCheck = History.getLastCheckTime(product);
        if (lastCheck == null) {
            return false;
        }
        Instant now = Instant.now();
        if (lastCheck.isAfter(now)) {
            return false;
        }
        Instant nextCheck = lastCheck.plus(Period.ofDays(1));
        return now.isBefore(nextCheck);
    }

    public static Instant getLastCheckTime(Product product) {
        String lastCheckKey = History.getLastCheckKey(product);
        long lastCheck = History.getPreferences().getLong(lastCheckKey, -1L);
        if (lastCheck == -1L) {
            History.getLogger().fine("License for " + product + " has never been checked");
            return null;
        }
        Instant lastCheckInstant = Instant.ofEpochMilli(lastCheck);
        History.getLogger().fine("Last check for " + product + " was on " + lastCheckInstant);
        return lastCheckInstant;
    }

    public static void setLastCheckTimeNow(Product product) {
        History.getLogger().fine("Marking license for " + product + " as checked now");
        History.getPreferences().putLong(History.getLastCheckKey(product), Instant.now().toEpochMilli());
    }

    private static String getLastCheckKey(Product product) {
        return "lastcheck-" + product.getName() + "-" + product.getVersion();
    }

    private static Preferences getPreferences() {
        return Preferences.userNodeForPackage(ProKeyValidator.class);
    }
}

