package com.vaadin.pro.licensechecker;

import java.awt.Desktop;
import java.awt.AWTError;
import java.io.IOException;
import java.net.URL;

import org.slf4j.Logger;

public class SystemBrowser {

    public static final String JAVA_HEADLESS_PROPERTY = "java.awt.headless";

    public static void open(String location) throws IOException {
        getLogger().debug("Launching system browser with URL " + location);
        try {
            URL url = new URL(location);

            // Temporarily turn headless false, it is is set to true.
            // Spring boot for example always puts it to true.
            // With the setting as false, opening the browser would be blocked.
            String headless = System.getProperty(JAVA_HEADLESS_PROPERTY);
            if (Boolean.valueOf(headless)) {
                try {
                    System.setProperty(JAVA_HEADLESS_PROPERTY, "false");
                    Desktop.getDesktop().browse(url.toURI());
                } finally {
                    System.setProperty(JAVA_HEADLESS_PROPERTY, headless);
                }
            } else {
                Desktop.getDesktop().browse(url.toURI());
            }
        } catch (IOException e) {
            throw e;
        } catch (Exception e) {
            throw new IOException(e);
        } catch (AWTError e) {
            throw new IOException(e);
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

}
