/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.OfflineKeyValidator;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.util.UUID;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class VaadinComIntegration {
    private static final String BASE_URL = "https://vaadin.com/pro/validate-license";
    private static final String MANUAL_PRO_KEY_URL = "https://vaadin.com/pro/validate-license";

    ProKey openBrowserAndWaitForKey(Product product, Consumer<String> noKeyUrlHandler, int timeoutSeconds) {
        String uniqueId = UUID.randomUUID().toString();
        String loginUrl = VaadinComIntegration.constructUrl(uniqueId, product);
        noKeyUrlHandler.accept(loginUrl);
        return this.listenForProKey("https://vaadin.com/pro/validate-license/connect/" + uniqueId, timeoutSeconds);
    }

    public static String constructUrl(String uniqueId, Product product) {
        String url = "https://vaadin.com/pro/validate-license?productName=" + product.getName() + "&productVersion=" + product.getVersion();
        if (uniqueId != null) {
            url = url + "&connect=" + uniqueId;
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ProKey listenForProKey(String location, int timeoutSeconds) {
        try {
            Instant timeout = Instant.now().plusSeconds(timeoutSeconds);
            URL url = new URL(location);
            while (Instant.now().isBefore(timeout)) {
                VaadinComIntegration.getLogger().debug("Polling server for pro key");
                try (InputStream in = url.openStream();){
                    String data = Util.toString(in);
                    ProKey proKey = ProKey.fromJson(data);
                    return proKey;
                }
                catch (FileNotFoundException e) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException throwable) {}
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new LicenseException("Error retreiving your subscription key from the server. Please try again or download the key manually from https://vaadin.com/pro/validate-license. If you need to work offline then " + OfflineKeyValidator.getOfflineKeyLinkMessage(MachineId.get()), e);
        }
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

