package com.vaadin.pro.licensechecker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Util {

    public static final int EOF = -1;

    public static String toString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
        copyLarge(in, out, new byte[1000]);
        return out.toString("UTF-8");
    }

    /**
     * From commons-io IOUtils. Included to avoid external dependencies.
     */
    public static long copyLarge(final InputStream input,
            final OutputStream output, final byte[] buffer) throws IOException {
        long count = 0;
        int n;
        while (EOF != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }
}
