package com.vaadin.pro.licensechecker;

import elemental.json.Json;
import elemental.json.JsonObject;

public class ProKey {
    /**
     * The username is not really needed. There was an idea early on that we should
     * construct a JWT for certain checks and that would have required
     * the username. In reality it has never been used for anything.
     */
    @Deprecated
    private String username;
    private String proKey;

    public ProKey(String username, String proKey) {
        super();
        this.username = username;
        this.proKey = proKey;
    }

    public static ProKey fromJson(String jsonData) {
        JsonObject json = Json.parse(jsonData);
        ProKey proKey = new ProKey(json.getString("username"),
                json.getString("proKey"));
        return proKey;
    }

    public String toJson() {
        JsonObject json = Json.createObject();
        json.put("username", username);
        json.put("proKey", proKey);
        return json.toJson();
    }

    public String getProKey() {
        return proKey;
    }

}
