/*
 * Copyright 2000-2024 Vaadin Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.vaadin.pro.licensechecker;

/**
 * An exception thrown when a license cannot be validated, for example because
 * of network errors in an online validation.
 */
public class LicenseValidationException extends LicenseException {

    /**
     * Constructs a new exception with the given detail message.
     *
     * @param message
     *            the detail message. The detail message is saved for later
     *            retrieval by the getMessage() method.
     */
    public LicenseValidationException(String message) {
        super(message);
    }

    /**
     * Constructs a new publishing exception with the specified detail message
     * and cause.
     * <p>
     * </p>
     * Note that the detail message associated with {@code cause} is <i>not</i>
     * automatically incorporated in this exception's detail message.
     *
     * @param message
     *            the detail message (which is saved for later retrieval by the
     *            {@link #getMessage()} method).
     * @param cause
     *            the cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A {@code null} value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.)
     */
    public LicenseValidationException(String message, Throwable cause) {
        super(message, cause);
    }

}
