package com.vaadin.pro.licensechecker.dau;

/**
 * License Server interaction phases.
 */
enum PublishingPhase {
    /**
     * Check the subscription key online with the License Server during building
     * Vaadin application for production.
     */
    CHECK,
    /**
     * Application server started. An empty user list is sent. Checks that
     * the subscription is valid and gets the initial enforcement rule.
     */
    START,
    /**
     * Periodical synchronization of DAU user, usually every 24 hours. Gets
     * the updated enforcement rule.
     */
    PERIOD,
    /**
     * Synchronization with License Server when enforcement is active,
     * performed frequently (by default every 5 minutes) to update the
     * enforcement rule as soon as possible to unlock the application new
     * users.
     */
    ENFORCE,
    /**
     * Application server stopped. Attempt to synchronize in memory data to
     * the License Server before shutdown completes.
     */
    STOP
}
