package com.vaadin.pro.licensechecker;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;

public class SystemBrowser {

    public static final String JAVA_HEADLESS_PROPERTY = "java.awt.headless";

    public static void open(String location)
            throws IOException, URISyntaxException {
        getLogger().fine("Launching system browser with URL " + location);
        URL url = new URL(location);

        // Temporarily turn headless false, it is is set to true.
        // Spring boot for example always puts it to true.
        // With the setting as false, opening the browser would be blocked.
        String headless = System.getProperty(JAVA_HEADLESS_PROPERTY);
        if (Boolean.valueOf(headless)) {
            System.setProperty(JAVA_HEADLESS_PROPERTY, "false");
            Desktop.getDesktop().browse(url.toURI());
            System.setProperty(JAVA_HEADLESS_PROPERTY, headless);
        } else {
            Desktop.getDesktop().browse(url.toURI());
        }

    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

}
