/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.ProKey;
import com.vaadin.pro.licensechecker.ProKeyValidator;
import com.vaadin.pro.licensechecker.Product;
import com.vaadin.pro.licensechecker.SystemBrowser;
import com.vaadin.pro.licensechecker.VaadinComIntegration;
import java.awt.HeadlessException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LicenseChecker {
    static Consumer<String> systemBrowserUrlHandler = url -> {
        try {
            LicenseChecker.getLogger().info("Opening system browser to validate license. If the browser is not opened, please open " + url + " manually");
            SystemBrowser.open(url);
        }
        catch (HeadlessException e) {
            LicenseChecker.getLogger().log(Level.SEVERE, "You are running in a headless environment. Please open " + url + " in any browser to validate the license.");
        }
        catch (IOException | UnsupportedOperationException | URISyntaxException e) {
            LicenseChecker.getLogger().log(Level.SEVERE, "Error opening system browser to validate license. Please open " + url + " manually", e);
        }
    };

    public static void checkLicenseFromStaticBlock(String productName, String productVersion) {
        try {
            LicenseChecker.checkLicense(productName, productVersion);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static void checkLicense(String productName, String productVersion) {
        LicenseChecker.checkLicense(productName, productVersion, systemBrowserUrlHandler);
    }

    public static void checkLicense(String productName, String productVersion, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.checkLicense(new Product(productName, productVersion), noKeyUrlHandler);
    }

    public static void checkLicenseAsync(String productName, String productVersion, Callback callback) {
        LicenseChecker.checkLicenseAsync(productName, productVersion, callback, systemBrowserUrlHandler);
    }

    public static void checkLicenseAsync(String productName, String productVersion, Callback callback, Consumer<String> noKeyUrlHandler) {
        new Thread(() -> {
            try {
                LicenseChecker.checkLicense(new Product(productName, productVersion), noKeyUrlHandler);
                callback.ok();
            }
            catch (Exception e) {
                callback.failed(e);
            }
        }).start();
    }

    private static void checkLicense(Product product, Consumer<String> noKeyUrlHandler) {
        LicenseChecker.getLogger().fine("Checking license for " + product);
        ProKey proKey = LocalProKey.get();
        if (proKey == null && (proKey = VaadinComIntegration.openBrowserAndWaitForKey(product, noKeyUrlHandler)) != null) {
            LocalProKey.write(proKey);
        }
        ProKeyValidator.validate(product, proKey, MachineId.get());
    }

    public static Logger getLogger() {
        return Logger.getLogger(LicenseChecker.class.getName());
    }

    public static interface Callback {
        public void ok();

        public void failed(Exception var1);
    }
}

