/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LocalProKey;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;

public class LocalOfflineKey {
    private static OfflineKey read(File offlineKeyLocation) throws IOException {
        if (!offlineKeyLocation.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(offlineKeyLocation);){
            OfflineKey offlineKey = OfflineKey.fromJson(Util.toString(is));
            return offlineKey;
        }
    }

    private static void write(File offlineKeyLocation, OfflineKey key) throws IOException {
        offlineKeyLocation.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(offlineKeyLocation);){
            out.write(key.toJson().getBytes(StandardCharsets.UTF_8));
        }
    }

    public static File getLocation() {
        return new File(LocalProKey.getVaadinFolder(), "offlineKey");
    }

    public static OfflineKey get() {
        OfflineKey offlineKey = LocalOfflineKey.getSystemProperty();
        if (offlineKey != null) {
            LocalOfflineKey.getLogger().debug("Using offlineKey from system property");
            return offlineKey;
        }
        File keyLocation = LocalOfflineKey.getLocation();
        try {
            offlineKey = LocalOfflineKey.read(keyLocation);
            LocalOfflineKey.getLogger().debug("Found offline key in " + keyLocation);
            return offlineKey;
        }
        catch (IOException e) {
            LocalOfflineKey.getLogger().debug("Unable to read offline key", (Throwable)e);
            return null;
        }
    }

    private static OfflineKey getSystemProperty() {
        String json = System.getProperty("vaadin.offlineKey");
        if (json == null) {
            return null;
        }
        return OfflineKey.fromJson(json);
    }

    static void write(OfflineKey key) throws IOException {
        File keyLocation = LocalOfflineKey.getLocation();
        LocalOfflineKey.getLogger().info("Writing offline key to " + keyLocation);
        LocalOfflineKey.write(keyLocation, key);
    }

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }
}

