/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.History;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.Product;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class OfflineKeyValidator {
    private static final Map<String, String> PUBLIC_KEYS = new HashMap<String, String>();

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    private static boolean isExpired(long expires) {
        return Instant.now().isAfter(Instant.ofEpochMilli(expires));
    }

    boolean validate(Product product, BuildType buildType, OfflineKey offlineKey, String machineId) {
        OfflineKeyValidator.getLogger().debug("Offline validation using offlineKey for " + product);
        if (offlineKey == null) {
            OfflineKeyValidator.getLogger().debug("No offline key found");
            return false;
        }
        if (History.isRecentlyValidated(product)) {
            OfflineKeyValidator.getLogger().debug("Skipping check as product license was recently validated.");
            return true;
        }
        this.validateOfflineKey(offlineKey, machineId);
        if (offlineKey.isProductionOnly()) {
            if (buildType != BuildType.PRODUCTION) {
                OfflineKeyValidator.getLogger().debug("Offline key is only for production");
                throw new LicenseException(OfflineKeyValidator.getOnlyProductionMessage(machineId));
            }
        } else if (!machineId.equals(offlineKey.getMachineId())) {
            OfflineKeyValidator.getLogger().debug("Offline key has incorrect machine id");
            throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId));
        }
        if (OfflineKeyValidator.isExpired(offlineKey.getExpires())) {
            OfflineKeyValidator.getLogger().debug("Offline key expired");
            throw new LicenseException(OfflineKeyValidator.getExpiredOfflineKeyMessage(machineId));
        }
        History.setLastCheckTimeNow(product);
        History.setLastSubscription(product, offlineKey.getSubscription());
        OfflineKeyValidator.getLogger().debug("Offline key OK");
        return true;
    }

    private void validateOfflineKey(OfflineKey offlineKey, String machineId) {
        try {
            String jwtData = offlineKey.getJwtData();
            SignedJWT jwt = (SignedJWT)JWTParser.parse((String)jwtData);
            String kid = jwt.getHeader().getKeyID();
            KeyFactory fact = KeyFactory.getInstance("EC");
            byte[] encoded = Base64.getDecoder().decode(PUBLIC_KEYS.get(kid));
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
            ECPublicKey publicKey = (ECPublicKey)fact.generatePublic(keySpec);
            ECDSAVerifier verifier = new ECDSAVerifier(publicKey);
            if (!jwt.verify((JWSVerifier)verifier)) {
                OfflineKeyValidator.getLogger().debug("Offline key failed verification");
                throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId));
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            OfflineKeyValidator.getLogger().debug("Offline key could not be read", (Throwable)e);
            throw new LicenseException(OfflineKeyValidator.getErrorValidatingOfflineKeyMessage(machineId), e);
        }
        catch (ParseException e) {
            OfflineKeyValidator.getLogger().debug("Error parsing offline key", (Throwable)e);
            throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId), e);
        }
        catch (JOSEException e) {
            OfflineKeyValidator.getLogger().debug("Error reading offline key", (Throwable)e);
            throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId), e);
        }
    }

    private static String getExpiredOfflineKeyMessage(String machineId) {
        return "Offline key has expired, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    private static String getOnlyProductionMessage(String machineId) {
        return "The provided offline key is only enabled for production builds, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static String getOfflineKeyLinkMessage(String machineId) {
        return "please go to " + OfflineKeyValidator.getOfflineUrl(machineId) + " to retrieve an offline key. For troubleshooting steps, see https://vaadin.com/licensing-faq-and-troubleshooting.";
    }

    public static String getOfflineUrl(String machineId) {
        return "https://vaadin.com/pro/validate-license?getOfflineKey=" + machineId;
    }

    private static String getErrorValidatingOfflineKeyMessage(String machineId) {
        return "Unable to validate offline key, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static String getInvalidOfflineKeyMessage(String machineId) {
        return "Invalid offline key, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static String getMissingOfflineKeyMessage(String machineId) {
        return "No offline key, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static {
        PUBLIC_KEYS.put("1", "MIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQBE7E9xWLjtmJZIeNhFZVPBIDwZRUIymfRXvkSN0h8/WEO6LzE2/eC9vlk/8E0/yPTS91f0/3Qn+BPfD3d6RjKs2kBOLprC4XCDrhwhLlnsncHV0oj64SspoBPWsCoeb2N7QYu/8ki5Re+/rxE/n0O5jZzruYEJT3ZS2DVOp+PUnxuvb0=");
    }
}

