/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import com.vaadin.pro.licensechecker.BuildType;
import com.vaadin.pro.licensechecker.History;
import com.vaadin.pro.licensechecker.LicenseChecker;
import com.vaadin.pro.licensechecker.LicenseException;
import com.vaadin.pro.licensechecker.MachineId;
import com.vaadin.pro.licensechecker.OfflineKey;
import com.vaadin.pro.licensechecker.Product;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.time.Instant;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class OfflineKeyValidator {
    private static final Map<String, String> PUBLIC_KEYS = new HashMap<String, String>();

    private static Logger getLogger() {
        return LicenseChecker.getLogger();
    }

    private static boolean isExpired(long expires) {
        return Instant.now().isAfter(Instant.ofEpochMilli(expires));
    }

    boolean validate(Product product, BuildType buildType, OfflineKey offlineKey, String machineId) {
        OfflineKeyValidator.getLogger().debug("Offline validation using offlineKey for " + product);
        if (offlineKey == null) {
            OfflineKeyValidator.getLogger().debug("No offline key found");
            return false;
        }
        if (product != null && History.isRecentlyValidated(product, buildType, null)) {
            OfflineKeyValidator.getLogger().debug("Skipping check as product license was recently validated.");
            return true;
        }
        this.validateOfflineKey(offlineKey, machineId);
        if (buildType != null) {
            if (buildType == BuildType.DEVELOPMENT && !offlineKey.isDevelopmentBuildAllowed()) {
                OfflineKeyValidator.getLogger().debug("Offline key is not for development");
                throw new LicenseException(OfflineKeyValidator.getNotDevelopmentMessage(machineId));
            }
            if (buildType == BuildType.PRODUCTION && !offlineKey.isProductionBuildAllowed()) {
                OfflineKeyValidator.getLogger().debug("Offline key is not for production builds");
                throw new LicenseException(OfflineKeyValidator.getNotProductionBuildMessage(machineId));
            }
        }
        if (offlineKey.getMachineId() != null) {
            String licenseMachineId = offlineKey.getMachineId();
            if (MachineId.isV2(licenseMachineId)) {
                if (!MachineId.equalsV2StableId(licenseMachineId)) {
                    OfflineKeyValidator.getLogger().debug("Offline key has incorrect machine id (v2)");
                    throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId));
                }
            } else if (!machineId.equals(licenseMachineId)) {
                OfflineKeyValidator.getLogger().debug("Offline key has incorrect machine id");
                throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId));
            }
        }
        if (OfflineKeyValidator.isExpired(offlineKey.getExpires())) {
            OfflineKeyValidator.getLogger().debug("Offline key expired");
            throw new LicenseException(OfflineKeyValidator.getExpiredOfflineKeyMessage(machineId));
        }
        if (product != null) {
            if (!this.containsProduct(offlineKey, product)) {
                throw new LicenseException("The offline key does not provide access to " + product.getName() + " " + product.getVersion());
            }
            History.setLastCheckTimeNow(product, buildType, null);
            History.setLastSubscription(product, offlineKey.getSubscription(), null);
        }
        OfflineKeyValidator.getLogger().debug("Offline key OK");
        return true;
    }

    private boolean containsProduct(OfflineKey offlineKey, Product product) {
        if (product.getName().startsWith("test-")) {
            return true;
        }
        boolean hasExtendedSupport = offlineKey.getAllowedFeatures().contains("extendedsupport");
        if ("vaadin-framework".equals(product.getName())) {
            if (product.getVersion().startsWith("7") && (hasExtendedSupport || offlineKey.getAllowedFeatures().contains("v7extendedsupport"))) {
                return true;
            }
            if (product.getVersion().startsWith("8") && (hasExtendedSupport || offlineKey.getAllowedFeatures().contains("v8extendedsupport"))) {
                return true;
            }
        } else if ("flow".equals(product.getName())) {
            return hasExtendedSupport;
        }
        return offlineKey.getAllowedProducts().contains(product.getName());
    }

    void validateOfflineKey(OfflineKey offlineKey, String machineId) {
        try {
            String jwtData = offlineKey.getJwtData();
            SignedJWT jwt = (SignedJWT)JWTParser.parse((String)jwtData);
            String kid = jwt.getHeader().getKeyID();
            KeyFactory fact = KeyFactory.getInstance("EC");
            byte[] encoded = Base64.getDecoder().decode(PUBLIC_KEYS.get(kid));
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encoded);
            ECPublicKey publicKey = (ECPublicKey)fact.generatePublic(keySpec);
            ECDSAVerifier verifier = new ECDSAVerifier(publicKey);
            if (!jwt.verify((JWSVerifier)verifier)) {
                OfflineKeyValidator.getLogger().debug("Offline key failed verification");
                throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId));
            }
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            OfflineKeyValidator.getLogger().debug("Offline key could not be read", (Throwable)e);
            throw new LicenseException(OfflineKeyValidator.getErrorValidatingOfflineKeyMessage(machineId), e);
        }
        catch (ParseException e) {
            OfflineKeyValidator.getLogger().debug("Error parsing offline key", (Throwable)e);
            throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId), e);
        }
        catch (JOSEException e) {
            OfflineKeyValidator.getLogger().debug("Error reading offline key", (Throwable)e);
            throw new LicenseException(OfflineKeyValidator.getInvalidOfflineKeyMessage(machineId), e);
        }
    }

    private static String getExpiredOfflineKeyMessage(String machineId) {
        return "Offline key has expired, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    private static String getNotDevelopmentMessage(String machineId) {
        return "The provided offline key does not allow development, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    private static String getNotProductionBuildMessage(String machineId) {
        return "The provided offline key does not allow production builds, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static String getOfflineKeyLinkMessage(String machineId) {
        return "please go to " + OfflineKeyValidator.getOfflineUrl(machineId) + " to retrieve an offline key.\nFor CI/CD build servers, you need to download a server license key, which can work offline to create production builds. You can download a server license key from https://vaadin.com/myaccount/licenses.\nFor troubleshooting steps, see https://vaadin.com/licensing-faq-and-troubleshooting.";
    }

    public static String getOfflineUrl(String machineId) {
        return "https://vaadin.com/pro/validate-license?getOfflineKey=" + machineId;
    }

    private static String getErrorValidatingOfflineKeyMessage(String machineId) {
        return "Unable to validate offline key, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static String getInvalidOfflineKeyMessage(String machineId) {
        return "Invalid offline key, " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static String getMissingOfflineKeyMessage(String machineId) {
        return "The license server at https://tools.vaadin.com/ could not be reached and no offline key was found. To use the product without an internet connection " + OfflineKeyValidator.getOfflineKeyLinkMessage(machineId);
    }

    static {
        PUBLIC_KEYS.put("b98c7421853a2d11fb2be2fb73f89be54414a4e9", "MIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQB/qMpeWPlOKTd8+93GSpi3s/CQMx1gpkw728vl8iijo2965zIBD1bePNULT9VK1iul2iNJA2ev9ImXecLAA4UoMwAlz3tQHIA8zJksNbQUHZhzS74hH/jJr9pE6ra4Q3lnNvmJKEXkFvCpUoBmdYS94Hu0MFXFi16IJfooLW6qzmtUGs=");
        PUBLIC_KEYS.put("542764e7000908e65dc3fc1dabf4e2cd28966758", "MIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQABaxDhdMljdpoM43y31co033oQjTZoCj+Wjby9LRBPmdlvMTAJV6gXOzZHDpXQb4N1O0NJr4AeXxaE4GO/p4GGywAkg+SYIO1v8X+n2beq1czN+i8WL1cfUu8DFITUkSHtULtPyNTvW1Ew7XeTGVUQ6n/Xz2YfAy7tcoFDsldrurE1nY=");
    }
}

