/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.open;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class FileUtil {
    public static String readFile(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String string = FileUtil.toString(in);
            return string;
        }
    }

    public static String read(InputStream inputStream) throws IOException {
        return FileUtil.toString(inputStream);
    }

    public static void copy(InputStream in, FileOutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
    }

    private static String toString(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            int charsRead;
            char[] buffer = new char[8192];
            while ((charsRead = reader.read(buffer)) != -1) {
                result.append(buffer, 0, charsRead);
            }
        }
        return result.toString();
    }
}

