/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.vaadin.signals.Id;
import com.vaadin.signals.Node;
import com.vaadin.signals.NodeSignal;
import com.vaadin.signals.SignalCommand;
import com.vaadin.signals.SignalEnvironment;
import com.vaadin.signals.impl.CommandResult;
import com.vaadin.signals.impl.ComputedSignal;
import com.vaadin.signals.impl.Effect;
import com.vaadin.signals.impl.SignalTree;
import com.vaadin.signals.impl.StagedTransaction;
import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.impl.TransientListener;
import com.vaadin.signals.impl.TreeRevision;
import com.vaadin.signals.impl.UsageTracker;
import com.vaadin.signals.operations.InsertOperation;
import com.vaadin.signals.operations.SignalOperation;
import com.vaadin.signals.operations.TransactionOperation;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class Signal<T> {
    private final SignalTree tree;
    private final Id id;
    private final Predicate<SignalCommand> validator;
    protected static final Predicate<SignalCommand> ANYTHING_GOES = anything -> true;

    protected Signal(SignalTree tree, Id id, Predicate<SignalCommand> validator) {
        this.tree = Objects.requireNonNull(tree);
        this.validator = Objects.requireNonNull(validator);
        this.id = Objects.requireNonNull(id);
    }

    protected Node.Data data(TreeRevision revision) {
        return revision.data(this.id()).orElse(null);
    }

    protected Node.Data data(Transaction transaction) {
        return this.data(transaction.read(this.tree()));
    }

    public T value() {
        Transaction transaction = Transaction.getCurrent();
        Node.Data data = this.data(transaction);
        if (transaction instanceof StagedTransaction && data != null) {
            this.submit(new SignalCommand.LastUpdateCondition(Id.random(), this.id(), data.lastUpdate()));
        }
        T value = this.extractValue(data);
        if (UsageTracker.isActive()) {
            UsageTracker.registerUsage(this.createUsage(transaction));
        }
        return value;
    }

    public T peek() {
        return this.extractValue(this.data(Transaction.getCurrent()));
    }

    public T peekConfirmed() {
        return this.extractValue(this.data(this.tree().confirmed()));
    }

    protected Predicate<SignalCommand> validator() {
        return this.validator;
    }

    protected Predicate<SignalCommand> mergeValidators(Predicate<SignalCommand> validator) {
        Predicate<SignalCommand> own = this.validator();
        if (own == ANYTHING_GOES) {
            return validator;
        }
        if (validator == ANYTHING_GOES) {
            return own;
        }
        return own.and(validator);
    }

    protected abstract T extractValue(Node.Data var1);

    protected abstract Object usageChangeValue(Node.Data var1);

    boolean isValid(SignalCommand command) {
        if (command instanceof SignalCommand.ConditionCommand) {
            return true;
        }
        if (command instanceof SignalCommand.TransactionCommand) {
            SignalCommand.TransactionCommand tx = (SignalCommand.TransactionCommand)command;
            return tx.commands().stream().allMatch(this::isValid);
        }
        return this.validator().test(command);
    }

    protected <R, O extends SignalOperation<R>> O submit(SignalCommand command, Function<CommandResult.Accept, R> resultConverter, O operation) {
        assert (command instanceof SignalCommand.RemoveCommand || this.id().equals(command.targetNodeId()));
        if (!this.isValid(command)) {
            throw new UnsupportedOperationException();
        }
        Executor dispatcher = SignalEnvironment.synchronousDispatcher();
        Transaction.getCurrent().include(this.tree(), command, result -> operation.result().completeAsync(() -> {
            if (result instanceof CommandResult.Accept) {
                CommandResult.Accept accept = (CommandResult.Accept)result;
                return new SignalOperation.Result(resultConverter.apply(accept));
            }
            if (result instanceof CommandResult.Reject) {
                CommandResult.Reject reject = (CommandResult.Reject)result;
                return new SignalOperation.Error(reject.reason());
            }
            throw new RuntimeException("Unsupported result type: " + result);
        }, dispatcher));
        return operation;
    }

    protected <O extends SignalOperation<Void>> O submitVoidOperation(SignalCommand command, O operation) {
        return this.submit(command, success -> null, operation);
    }

    protected <I extends Signal<?>> InsertOperation<I> submitInsert(SignalCommand command, Function<Id, I> childFactory) {
        return this.submitVoidOperation(command, new InsertOperation<Signal>((Signal)childFactory.apply(command.commandId())));
    }

    protected <R> SignalOperation<R> submit(SignalCommand command, Function<CommandResult.Accept, R> resultConverter) {
        return this.submit(command, resultConverter, new SignalOperation());
    }

    protected SignalOperation<Void> submit(SignalCommand command) {
        return this.submitVoidOperation(command, new SignalOperation());
    }

    public Id id() {
        return this.id;
    }

    protected SignalTree tree() {
        return this.tree;
    }

    protected UsageTracker.Usage createUsage(Transaction transaction) {
        final Object originalValue = this.usageChangeValue(this.data(transaction));
        return new UsageTracker.Usage(){

            @Override
            public boolean hasChanges() {
                return !Objects.equals(originalValue, Signal.this.usageChangeValue(Signal.this.data(Transaction.getCurrent())));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Runnable onNextChange(TransientListener listener) {
                SignalTree tree = Signal.this.tree();
                tree.getLock().lock();
                try {
                    boolean listenToNext;
                    if (this.hasChanges() && !(listenToNext = listener.invoke())) {
                        Runnable runnable = () -> {};
                        return runnable;
                    }
                    Runnable runnable = tree.observeNextChange(Signal.this.id(), () -> {
                        if (this.hasChanges()) {
                            return listener.invoke();
                        }
                        return true;
                    });
                    return runnable;
                }
                finally {
                    tree.getLock().unlock();
                }
            }
        };
    }

    protected NodeSignal asNode() {
        assert (!(this instanceof NodeSignal));
        return new NodeSignal(this.tree(), this.id(), this.validator());
    }

    protected SignalOperation<Void> clear() {
        return this.submit(new SignalCommand.ClearCommand(Id.random(), this.id()));
    }

    protected SignalOperation<Void> remove(Signal<?> child) {
        return this.submit(new SignalCommand.RemoveCommand(Id.random(), child.id(), this.id()));
    }

    protected static JsonNode toJson(Object value) {
        return SignalEnvironment.objectMapper().valueToTree(value);
    }

    protected static <T> T fromJson(JsonNode value, Class<T> targetType) {
        try {
            return (T)SignalEnvironment.objectMapper().treeToValue((TreeNode)value, targetType);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static <T> T nodeValue(Node node, Class<T> valueType) {
        assert (node instanceof Node.Data);
        return Signal.fromJson(((Node.Data)node).value(), valueType);
    }

    public static Runnable effect(Runnable action) {
        Effect effect = new Effect(Objects.requireNonNull(action));
        return effect::dispose;
    }

    public static <T> Signal<T> computed(Supplier<T> computation) {
        return new ComputedSignal<T>(computation);
    }

    public <C> Signal<C> map(Function<T, C> mapper) {
        return Signal.computed(() -> mapper.apply(this.value()));
    }

    public static <T> TransactionOperation<T> runInTransaction(Supplier<T> transactionTask) {
        return Transaction.runInTransaction(transactionTask);
    }

    public static TransactionOperation<Void> runInTransaction(Runnable transactionTask) {
        return Transaction.runInTransaction(transactionTask);
    }

    public static <T> T runWithoutTransaction(Supplier<T> task) {
        return Transaction.runWithoutTransaction(task);
    }

    public static void runWithoutTransaction(Runnable task) {
        Transaction.runWithoutTransaction(task);
    }

    public static <T> T untracked(Supplier<T> task) {
        return UsageTracker.untracked(task);
    }
}

