/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.signals.impl;

import com.vaadin.signals.impl.Transaction;
import com.vaadin.signals.impl.TransientListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;

public class UsageTracker {
    private static final Usage NO_USAGE = new Usage(){

        @Override
        public boolean hasChanges() {
            return false;
        }

        @Override
        public Runnable onNextChange(TransientListener listener) {
            return () -> {};
        }
    };
    private static final ThreadLocal<Collection<Usage>> currentTracker = new ThreadLocal();

    private UsageTracker() {
    }

    public static Usage track(Runnable task) {
        ArrayList<Usage> usages = new ArrayList<Usage>();
        Collection<Usage> previousTracker = currentTracker.get();
        try {
            currentTracker.set(usages);
            Transaction.runInTransaction(task, Transaction.Type.READ_ONLY);
        }
        finally {
            currentTracker.set(previousTracker);
        }
        int usageSize = usages.size();
        if (usageSize == 0) {
            return NO_USAGE;
        }
        if (usageSize == 1) {
            return (Usage)usages.iterator().next();
        }
        return new CombinedUsage(usages);
    }

    public static <T> T untracked(Supplier<T> task) {
        Collection<Usage> previousTracker = currentTracker.get();
        if (previousTracker == null) {
            return task.get();
        }
        try {
            currentTracker.remove();
            T t = Transaction.runWithoutTransaction(task);
            return t;
        }
        finally {
            currentTracker.set(previousTracker);
        }
    }

    public static void registerUsage(Usage usage) {
        Collection<Usage> tracker = currentTracker.get();
        assert (tracker != null);
        tracker.add(usage);
    }

    public static boolean isActive() {
        return currentTracker.get() != null;
    }

    public static interface Usage {
        public boolean hasChanges();

        public Runnable onNextChange(TransientListener var1);
    }

    static final class CombinedUsage
    implements Usage {
        private final Collection<Usage> usages;

        CombinedUsage(Collection<Usage> usages) {
            this.usages = usages;
        }

        @Override
        public boolean hasChanges() {
            return this.usages.stream().anyMatch(Usage::hasChanges);
        }

        @Override
        public Runnable onNextChange(final TransientListener listener) {
            return new Runnable(){
                final Object lock = new Object();
                final Collection<Runnable> cleanups = new ArrayList<Runnable>();
                boolean closed = false;
                {
                    Object object = this.lock;
                    synchronized (object) {
                        for (Usage usage : usages) {
                            Runnable cleanup = usage.onNextChange(this::onChange);
                            if (this.closed) {
                                cleanup.run();
                                break;
                            }
                            this.cleanups.add(cleanup);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private boolean onChange() {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.closed) {
                            return false;
                        }
                        boolean listenToNext = listener.invoke();
                        if (!listenToNext) {
                            this.close();
                        }
                        return listenToNext;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void close() {
                    Object object = this.lock;
                    synchronized (object) {
                        this.closed = true;
                        this.cleanups.forEach(Runnable::run);
                        this.cleanups.clear();
                    }
                }

                @Override
                public void run() {
                    this.close();
                }
            };
        }
    }
}

