package com.vaadin.uitest.model;

import java.util.Arrays;

public enum TestFramework {

    TEST_BENCH("Vaadin TestBench", "TestBench"),

    PLAYWRIGHT_JAVA("Playwright Java", "Playwright"),

    PLAYWRIGHT_NODE("Playwright Node.js", "PlaywrightNode");

    private final String label;

    private final String value;

    TestFramework(String label, String value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public String getValue() {
        return value;
    }

    public static TestFramework getByValue(String testFrameworkValue) {
        return Arrays
                .stream(values()).filter(testFramework -> testFramework
                        .getValue().equals(testFrameworkValue))
                .findAny().orElse(null);
    }
}
