/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.applayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.AppLayoutMenu;
import com.vaadin.flow.component.applayout.AppLayoutMenuItem;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.RouteNotFoundError;
import com.vaadin.flow.router.RouterLayout;

public abstract class AbstractAppRouterLayout
implements RouterLayout {
    private AppLayout appLayout = new AppLayout();
    private AppLayoutMenu appLayoutMenu = this.appLayout.createMenu();

    protected AbstractAppRouterLayout() {
        this.configure(this.getAppLayout(), this.getAppLayoutMenu());
    }

    protected abstract void configure(AppLayout var1, AppLayoutMenu var2);

    protected void beforeNavigate(String route, HasElement content) {
    }

    protected void afterNavigate(String route, HasElement content) {
    }

    public void showRouterLayoutContent(HasElement content) {
        Component component = (Component)content.getElement().getComponent().get();
        String target = null;
        if (component instanceof RouteNotFoundError) {
            this.getAppLayoutMenu().selectMenuItem(null);
        } else {
            target = UI.getCurrent().getRouter().getUrl(component.getClass());
            this.getAppLayoutMenu().getMenuItemTargetingRoute(target).ifPresent(item -> this.getAppLayoutMenu().selectMenuItem((AppLayoutMenuItem)((Object)item), false));
        }
        this.beforeNavigate(target, content);
        this.getAppLayout().setContent(content.getElement());
        this.afterNavigate(target, content);
    }

    public Element getElement() {
        return this.getAppLayout().getElement();
    }

    public AppLayout getAppLayout() {
        return this.appLayout;
    }

    public AppLayoutMenu getAppLayoutMenu() {
        return this.appLayoutMenu;
    }
}

