/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.applayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.applayout.AppLayoutMenu;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.dom.Element;
import java.util.Objects;

@Tag(value="vaadin-app-layout")
@HtmlImport(value="frontend://bower_components/vaadin-app-layout/src/vaadin-app-layout.html")
public class AppLayout
extends Component {
    private Element branding;
    private Element content;
    private Element menu;

    public void setBranding(Component branding) {
        this.setBranding(AppLayout.toElement((HasElement)branding));
    }

    public void setBranding(Element branding) {
        Objects.requireNonNull(branding, "Branding cannot be null");
        this.removeBranding();
        this.branding = branding;
        branding.setAttribute("slot", "branding");
        this.getElement().appendChild(new Element[]{branding});
    }

    public void removeBranding() {
        this.remove(this.branding);
        this.branding = null;
    }

    public Element getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        this.setContent(AppLayout.toElement((HasElement)content));
    }

    public void setContent(Element content) {
        Objects.requireNonNull(content, "Content cannot be null");
        this.removeContent();
        this.content = content;
        this.getElement().appendChild(new Element[]{content});
    }

    public void removeContent() {
        this.remove(this.content);
        this.content = null;
    }

    public Element getMenu() {
        return this.menu;
    }

    public void setMenu(HasElement menu) {
        this.setMenu(AppLayout.toElement(menu));
    }

    public void setMenu(Element menu) {
        Objects.requireNonNull(menu, "Menu cannot be null");
        this.removeMenu();
        this.menu = menu;
        menu.setAttribute("slot", "menu");
        this.getElement().appendChild(new Element[]{menu});
    }

    public AppLayoutMenu createMenu() {
        AppLayoutMenu menu = new AppLayoutMenu();
        this.setMenu(menu);
        return menu;
    }

    public void removeMenu() {
        this.remove(this.menu);
        this.menu = null;
    }

    private void remove(Element element) {
        if (element != null) {
            element.removeFromParent();
        }
    }

    private static Element toElement(HasElement hasElement) {
        return hasElement != null ? hasElement.getElement() : null;
    }
}

