/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.applayout;

import com.vaadin.flow.component.AttachNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.applayout.AppLayoutMenuItem;
import com.vaadin.flow.component.applayout.MenuItemClickEvent;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.dom.Element;
import java.util.Objects;
import java.util.Optional;

public class AppLayoutMenu
implements HasElement,
AttachNotifier {
    private final Tabs tabs = new Tabs();
    private final SelectionChangeListener selectionChangeListener = new SelectionChangeListener();
    private AppLayoutMenuItem selectedMenuItem;

    public AppLayoutMenu() {
        this.tabs.addSelectedChangeListener((ComponentEventListener)this.selectionChangeListener);
    }

    public void setMenuItems(AppLayoutMenuItem ... menuItems) {
        this.clearMenuItems();
        this.addMenuItems(menuItems);
    }

    public void addMenuItems(AppLayoutMenuItem ... menuItems) {
        try {
            this.selectionChangeListener.enabled = false;
            this.tabs.add((Tab[])menuItems);
        }
        finally {
            this.selectionChangeListener.enabled = true;
        }
        if (this.selectedMenuItem == null) {
            this.tabs.setSelectedIndex(-1);
        }
    }

    public AppLayoutMenuItem addMenuItem(String title) {
        return this.addAndReturn(new AppLayoutMenuItem(title));
    }

    public AppLayoutMenuItem addMenuItem(AppLayoutMenuItem item) {
        return this.addAndReturn(item);
    }

    public AppLayoutMenuItem addMenuItem(Component icon) {
        return this.addAndReturn(new AppLayoutMenuItem(icon));
    }

    public AppLayoutMenuItem addMenuItem(Component icon, String title) {
        return this.addAndReturn(new AppLayoutMenuItem(icon, title));
    }

    public AppLayoutMenuItem addMenuItem(Component icon, String title, String route) {
        return this.addAndReturn(new AppLayoutMenuItem(icon, title, route));
    }

    public AppLayoutMenuItem addMenuItem(Component icon, ComponentEventListener<MenuItemClickEvent> listener) {
        return this.addAndReturn(new AppLayoutMenuItem(icon, listener));
    }

    public AppLayoutMenuItem addMenuItem(String title, ComponentEventListener<MenuItemClickEvent> listener) {
        return this.addAndReturn(new AppLayoutMenuItem(title, listener));
    }

    public AppLayoutMenuItem addMenuItem(Component icon, String title, ComponentEventListener<MenuItemClickEvent> listener) {
        return this.addAndReturn(new AppLayoutMenuItem(icon, title, listener));
    }

    private AppLayoutMenuItem addAndReturn(AppLayoutMenuItem item) {
        this.addMenuItems(item);
        return item;
    }

    public void removeMenuItem(AppLayoutMenuItem menuItem) {
        if (Objects.equals((Object)this.selectedMenuItem, (Object)menuItem)) {
            this.selectedMenuItem = null;
        }
        this.tabs.remove(new Component[]{menuItem});
    }

    public void clearMenuItems() {
        this.selectedMenuItem = null;
        this.tabs.removeAll();
    }

    public void selectMenuItem(AppLayoutMenuItem menuItem) {
        this.selectMenuItem(menuItem, true);
    }

    void selectMenuItem(AppLayoutMenuItem menuItem, boolean fireSelectionChange) {
        try {
            if (!fireSelectionChange) {
                this.selectionChangeListener.enabled = false;
            }
            this.selectedMenuItem = menuItem;
            this.tabs.setSelectedTab((Tab)menuItem);
        }
        finally {
            if (!fireSelectionChange) {
                this.selectionChangeListener.enabled = true;
            }
        }
    }

    public Optional<AppLayoutMenuItem> getMenuItemTargetingRoute(String route) {
        Objects.requireNonNull(route, "Route can not be null");
        return this.tabs.getChildren().map(AppLayoutMenuItem.class::cast).filter(e -> route.equals(e.getRoute())).findFirst();
    }

    public AppLayoutMenuItem getSelectedMenuItem() {
        return this.selectedMenuItem;
    }

    public Element getElement() {
        return this.tabs.getElement();
    }

    private class SelectionChangeListener
    implements ComponentEventListener<Tabs.SelectedChangeEvent> {
        private boolean enabled = true;

        private SelectionChangeListener() {
        }

        public void onComponentEvent(Tabs.SelectedChangeEvent event) {
            AppLayoutMenuItem selectedTab = (AppLayoutMenuItem)AppLayoutMenu.this.tabs.getSelectedTab();
            if (this.enabled && selectedTab != null) {
                if (selectedTab.getRoute() == null) {
                    if (AppLayoutMenu.this.selectedMenuItem != null) {
                        AppLayoutMenu.this.tabs.setSelectedTab((Tab)AppLayoutMenu.this.selectedMenuItem);
                    } else {
                        AppLayoutMenu.this.tabs.setSelectedIndex(-1);
                    }
                } else {
                    AppLayoutMenu.this.selectedMenuItem = selectedTab;
                }
                selectedTab.fireMenuItemClickEvent();
            }
        }
    }
}

